#!/bin/sh
# MetaCard 2.4 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  w 2lz3 00  ;function prefslesen was
  switch the platform
  case "MacOS"
    put specialFolderPath("preferences") into spfp
    break
  case "Win32"
    if the systemversion contains "NT" then
      put specialFolderPath(35) into spfp
    else
      put specialfolderpath("system") into spfp
    end if
    break
  default
    put $HOME into spfp
    break
  end switch
  if there is not a folder (spfp & "/major-k") then create folder (spfp & "/major-k")
  if there is not a folder (spfp & "/major-k/2lz3") then create folder (spfp & "/major-k/2lz3")
  if was = 1 then
    if there is a file (spfp & "/major-k/2lz3/2lz3.prf") then
      put url("file:" & spfp & "/major-k/2lz3/2lz3.prf") into dieprefs
      if the num of lines of dieprefs <> 9 then
        put "nix" into dieprefs
      end if
    else
      put "nix" into dieprefs
    end if
  else
    if there is a file (spfp & "/major-k/2lz3/favourites.prf") then
      put url("file:" & spfp & "/major-k/2lz3/favourites.prf") into dieprefs
    else
      put "nix" into dieprefs
    end if
  end if
  return dieprefs
end prefslesen

on prefsschreiben was, wohin
  switch the platform
  case "MacOS"
    put specialFolderPath("preferences") into spfp
    break
  case "Win32"
    if the systemversion contains "NT" then
      put specialFolderPath(35) into spfp
    else
      put specialfolderpath("system") into spfp
    end if
    break
  default
    put $HOME into spfp
    break
  end switch
  if there is not a folder (spfp & "/major-k") then create folder (spfp & "/major-k")
  if there is not a folder (spfp & "/major-k/2lz3") then create folder (spfp & "/major-k/2lz3")
  if wohin = 1 then
    put was into url("file:" & spfp & "/major-k/2lz3/2lz3.prf")
  else
    put was into url("file:" & spfp & "/major-k/2lz3/favourites.prf")
  end if
end prefsschreiben

on changeTool
  get word 1 of the tool
  if it is "graphic"
  then get the style of the templateGraphic
  set the hilitedButton of group "icons" to \
      itemOffset(it, "browse,pointer,button,field,scrollbar,image,player,line,polygon,curve,rectangle,oval,roundrect,regular")
end changeTool
  q          white          @   defaultloc  vertikal
0,23,64,593
orientierung  vertikaltp  1
defaultprefs  "true
true
true
true
true
true
truealtloc  vertikal
2,0,66,516	vorprefs  "true
true
true
true
true
true
true             "  U 
helvetica   U 
helvetica   U Arial  
 U Arial  
 U 
helvetica   U Arial  
 U Lucida Grande  
 U Lucida Grande  
 U 
Helvetica  	 U Lucida Grande   U Lucida Grande   U Lucida Grande  
 W Lucida Grande   W Lucida Grande   W Lucida Grande   W Lucida Grande  
 W Lucida Grande   U Lucida Grande   U Arial   W Arial  	 U Arial  	 W Arial   U Arial  
 W Arial   W Lucida Grande  
U Arial   W Arial   W Arial  	U Arial  	W Arial  	 W Apple Chancery   W Apple Chancery  U Apple Chancery   U Arial  cREVGeneral    
bookmarks   handlerList  prefslesen
prefsschreibenscriptSelection  char 1 to 23prevHandler  
prefslesentempScript   script    
cREVLoadInfo    load  startupmode  Palette      P^on preopenstack
  set the decorations of this stack to empty
  get prefslesen(1)
  if it <> "nix" then
    set the vorprefs of this stack to line 1 to 7 of it
    set the altloc of this stack to line 8 to 9 of it
  else
    set the vorprefs of this stack to the defaultprefs of this stack
    set the altloc of this stack to the defaultloc of this stack
  end if
  get prefslesen(2)
  if it <> "nix" then
    set the altloc of stack "favourites" to it
  else
    set the altloc of stack "favourites" to 179,156,345,513
  end if
  set the style of this stack to "palette"
end preopenstack

on preOpenCard
  changeTool
end preOpenCard

on machvertikal
  lock screen
  put the topleft of  stack "2lz3" into obenlinks
  repeat with i = 1 to the num of controls of cd 1
    set the loc of control i of cd 1 to (the vertikal of control i of cd 1)
  end repeat
  set the rect of fld "dasding" of cd 1 to 0,427,64,460
  set the width of stack "2lz3" to 64
  set the height of stack "2lz3" to 516
  
  set the topleft of stack "2lz3" to obenlinks
  unlock screen
  set the orientierung of  stack "2lz3" to "vertikal"
  set the altloc of stack "2lz3" to "vertikal" & CR & the rect of stack "2lz3"
end machvertikal

on machhorizontal
  put the topleft of stack "2lz3" into obenlinks
  lock screen
  repeat with i = 1 to the num of controls of cd 1
    set the loc of control i of cd 1 to (the horizontal of control i of cd 1)
  end repeat
  
  set the width of  stack "2lz3" to 726
  set the height of stack "2lz3" to 60
  set the topleft of  stack "2lz3" to obenlinks
  
  unlock screen
  set the orientierung of  stack "2lz3" to "horizontal"
  set the altloc of  stack "2lz3" to "vertikal" & CR & the rect of  stack "2lz3"
  set the rect of fld "dasding" of cd 1 to 15,0,205,32
end machhorizontal

on openCard
  set the hilite of btn "selgrp" to the selectgroupedcontrols
end openCard

on openStack
  insert script of button "MenuButton" of stack "MetaCard Menu Bar" into front
  insert script of button "newobj" of stack "MetaCard Menu Bar" into back
  insert script of btn "dertrigger" of cd 1 of this stack into front
  insert script of button "revfake" of cd 1 of this stack into back
  newTool
  einstellen
end openStack

on closestack
  remove script of btn "dertrigger" of cd 1 of this stack from front
  remove script of btn "revfake" of cd 1 of this stack from back
  prefsschreiben (the vorprefs of this stack & CR & the orientierung of this stack & CR & the rect of this stack), 1
end closestack

on einstellen
  lock screen
  get the vorprefs of this stack
  if line 1 of it = "true" then
    set the tp of this stack to 1
  else
    set the tp of this stack to 0
  end if
  if line 2 of it = "false" then
    exit einstellen
  end if
  get the altloc of this stack
  if line 1 of it = "vertikal" then
    machvertikal
  else
    machhorizontal
  end if
  #  set the rect of this stack to line 2 of it
  unlock screen
end einstellen

on istwahl
  put empty into field "dasding"
  put empty into field "breit"
  put empty into field "hoch"
  put empty into field "loc1"
  put empty into field "loc2"
end istwahl

on leer welchesfeld
  if welchesfeld is empty then exit to metacard
  if welchesfeld is not a number then exit to metacard
end leer

on scheckung
  if the selobj is empty then
    istwahl
    exit to metacard
  end if
  if the number of lines in (the selobj) > 1 then
    istwahl
    exit to metacard
  end if
  put the selobj into field "dasding"
  put the width of the selobj into field "breit"
  put the height of the selobj into field "hoch"
  get the loc of the selobj
  put item 1 of it into field "loc1"
  put item 2 of it into field "loc2"
end scheckung
      u     @     cREVGeneral    
bookmarks   handlerList  XopenCard
openStack
closestack
preopenstack
einstellen
istwahl
leer
scheckung
preOpenCardscriptSelection  char 598 to 694prevHandler  
closestacktempScript   script     u  s  r  q            	  
          4  P  Q  S  W  X  Z  \  ]  ^  _  `      b  =  -  t    w   set W/H Ew on mouseUp
  if the selobj is empty then exit to metacard
  leer field "breit"
  leer field "hoch"
  set the width of the selobj to field "breit"
  set the height of the selobj to field "hoch"
  send "mouseup" to btn "set Loc"
end mouseUp
       , 0 Q    	vertikal  84,58horizontal  84,58         	        set Loc Ew on mouseUp
  if the selobj is empty then exit to metacard
  leer field "loc1"
  leer field "loc2"
  set the loc of the selobj to field "loc1", Field "loc2"
end mouseUp
       d  Q    	vertikal  140,36horizontal  140,36         	        del this cd !!! Dwon mouseUp
  set the defaultstack to the topstack
  if the short name of the topstack = "2lz3" then exit mouseup
  if the altkey is not "down" then
    answer error "Really delete THIS card: " & CR & the long name of this cd & CR & CR & "No fooling???" & CR &  "I'll do it, seriously!" with "DO IT!!!" or "Cancel" as sheet
    if it is "Cancel" then exit mouseup
  end if
  # set the defaultstack to the topstack
  set the lockmessages to true
  delete this card
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Will REALLY delete the current card of  stack:" && QUOTE & the short name of the topstack && QUOTE & "!" && "Press ALT to suppress dialog..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
             @    	vertikal  32,509horizontal  694,53 XWill REALLY delete the current card of  stack: "Home "! Press ALT to suppress dialog...           cREVGeneral    scriptChecksum  >J#{`
bookmarks   handlerList  mouseUp
mouseentertempScript   prevHandler  
mouseenterscriptSelection  char 264 to 263script <p>on mouseUp</p>
<p>  set the defaultstack to the topstack</p>
<p>  if the short name of the topstack = &quot;heim2&quot; then exit mouseup</p>
<p>  if the altkey is not &quot;down&quot; then</p>
<p>    answer error &quot;Really delete THIS card: &quot; &amp; CR &amp; the long name of this cd &amp; CR &amp; CR &amp; &quot;No fooling???&quot; &amp; CR &amp;  &quot;I'll do it, seriously!&quot; with &quot;DO IT!!!&quot; or &quot;Cancel&quot; as sheet</p>
<p>    if it is &quot;Cancel&quot; then exit mouseup</p>
<p>  end if</p>
<p>  # set the defaultstack to the topstack</p>
<p>  set the lockmessages to true</p>
<p>  delete this card</p>
<p>end mouseUp</p>
<p></p>
<p>on mouseenter</p>
<p>  if the tp of this stack is &quot;1&quot; then</p>
<p>    set the tooltip of me to &quot;Will REALLY delete the current card of the topstack! Press ALT to suppress dialog...&quot;</p>
<p>  else</p>
<p>    set the tooltip of me to empty</p>
<p>  end if</p>
<p>end mouseenter</p>
<p></p>	     4 dertrigger  @on escapekey
  put lineoffset("action",the pendingmessages) into zeile
  if zeile > 0 then
    cancel item 1 of line zeile of the pendingmessages
  end if
  pass escapekey
end escapekey

on newTool
  send "changeTool" to stack "2lz3"
  pass newtool
end newtool
         < <   	vertikal  188,186horizontal  188,186         	   	        params  ion returnInField
  send "mouseup" to btn "set W/H"
  pass returninfield
end returnInField

on enterInField
  send "mouseup" to btn "set W/H"
  pass enterinfield
end enterInField

on mouseenter
  if the owner of the target is not me then exit mouseenter
  if the tp of this stack = 1 then
    set the tooltip of the target to "Type a value and press RETURN/ENTER to set..."
  else
    set the tooltip of the target to empty
  end if
end mouseenter
       T <   	vertikal  31,482horizontal  241,22
   width 	        $     horizontal  221,11	vertikal  11,472 .Type a value and press RETURN/ENTER to set...            W 
   heigth 	         $     horizontal  253,11	vertikal  43,472 .Type a value and press RETURN/ENTER to set...            H 
   x-loc 	        ,     horizontal  225,33	vertikal  15,492 .Type a value and press RETURN/ENTER to set...            X 
   y-loc 	         ,     horizontal  257,33	vertikal  47,492 .Type a value and press RETURN/ENTER to set...            Y 
  8 breit  k(  
    @        	vertikal  16,471horizontal  226,10 .Type a value and press RETURN/ENTER to set...           
  9 hoch  k(  
    @        horizontal  258,10	vertikal  48,471 .Type a value and press RETURN/ENTER to set...           
  : loc1  k(  
    @        	vertikal  16,491horizontal  226,32 .Type a value and press RETURN/ENTER to set...           
  ; loc2  k(  
    @        horizontal  258,32	vertikal  48,491 .Type a value and press RETURN/ENTER to set...             
 >| e  Yon mouseUp
  set the defaultstack to the topstack
  if the altkey is "down" then set the lockmessages to true
  go last cd
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Go to last card. Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
  scheckung
end mouseenter
         F      	vertikal  48,77horizontal  189,39 /Go to last card. Press ALT to lock messages...  >>          	        > E  Yon mouseUp
  set the defaultstack to the topstack
  if the altkey is "down" then set the lockmessages to true
  go next cd
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Go to next card. Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
  scheckung
end mouseenter
         9      	vertikal  48,64horizontal  157,39 /Go to next card. Press ALT to lock messages...          	        	new card DwGon mouseUp
  set the defaultstack to the topstack
  create card
  palette "Properties"
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Create a new card in stack" && QUOTE & the short name of the topstack & QUOTE
  else
    set the tooltip of me to empty
  end if
end mouseenter
        O @    	vertikal  32,342horizontal  503,39 &Create a new card in stack "einstein"          	     	 |< e  [on mouseUp
  set the defaultstack to the topstack
  if the altkey is "down" then set the lockmessages to true
  go first cd
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Go to first card. Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
  scheckung
end mouseenter
         F      	vertikal  16,77horizontal  94,39 0Go to first card. Press ALT to lock messages...  <<          	        < E  ]on mouseUp
  set the defaultstack to the topstack
  if the altkey is "down" then set the lockmessages to true
  go prev cd
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Go to previous card. Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
  scheckung
end mouseenter
         9      	vertikal  16,64horizontal  126,39 3Go to previous card. Press ALT to lock messages...          	        
new stack 	uon menupick was
  if was is "other..." then
    ask "Please enter desired width and height, separated by COMMA. Thanks ;-)" as sheet
    if the result is "Cancel" then exit menupick
    if the num of items of it is not 2 then exit menupick
    put item 1 of it into w
    if w is not a number then then exit menupick
    put item 2 of it into h
    if h is not a number then exit menupick
    put w & "," & h into was
  end if
  set the width of the templatestack to item 1 of was
  set the height of the templatestack to item 2 of was
  set the loc of the templatestack to the screenloc
  
  get the vorprefs of this stack
  
  set the alwaysbuffer of the templatestack to (line 3 of it)
  set the destroystack of the templatestack to (line 4 of it)
  set the destroywindow of the templatestack to (line 5 of it)
  set the resizable of the templatestack to (line 6 of it)
  put line 7 of it into mitscript
  create stack
  if mitscript then set the script of the topstack to fld "dndscript"
  select the topStack
  palette "properties"
end menupick

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "New stack with predefined or custom size..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
        \ @    	vertikal  32,355horizontal  503,53 ,New stack with predefined or custom size...                           D128,128
256,256
384,288
640,480
768,576
800,600
1024,768
-
other...       	      open stack... Dwon mouseUp
  if the altkey is "down" then
    set the lockmessages to true
  end if
  answer file "What stack may i open for you?"
  if the result is not "cancel" then
    try
      toplevel it
    catch errornum
      beep
    end try
  end if
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Will open any valid stack. Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
         + @    horizontal  110,53	vertikal  32,50 9Will open any valid stack. Press ALT to lock messages...          	     P selgrp @don mouseup
  set the selectgroupedcontrols to the hilite of me
end mouseup

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Toggle selectgroupedcontrols..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
      > ?    horizontal  240,52	vertikal  30,326  Toggle selectgroupedcontrols...  selgrob          	     Q 
set vertical Ep on mouseUp
  repeat with i = 1 to the num of controls
    set the vertikal of control i to the loc of control i
  end repeat
end mouseUp
       ,  (   	vertikal  283,320horizontal  283,323         	       S set horizontal Epon mouseUp
##  answer the num of controls of cd 1 of stack "2lz3"
  repeat with i = 1 to the num of controls of cd 1 of stack "2lz3"
    set the horizontal of control i of cd 1 of stack "2lz3" to the loc of control i of cd 1 of stack "2lz3"
  end repeat
end mouseUp
          (   	vertikal  279,276horizontal  320,396         	       W card props Dwon mouseUp
  select this cd of the topStack
  palette "properties"
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Open the property palette for the current card..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
        i @    horizontal  311,39	vertikal  32,368 2Open the property palette for the current card...          	     X stack props Dw	on mouseUp
  select the topStack
 palette "properties"
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Open the property palette for the top-stack..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
        v @    	vertikal  32,381horizontal  311,53 /Open the property palette for the top-stack...          	     Z 
ctrl browser Dw on mouseUp
  modeless "Control Browser"
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Will open the Control Browser..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
        0 @    	vertikal  32,311horizontal  567,53 !Will open the Control Browser...          	     \ obj script Dw%on mouseUp
  repeat for each line l in (the selobj)
    edit script of l
  end repeat
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Edit script(s) of the selected object(s)..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
         @    horizontal  375,39	vertikal  32,394 ,Edit script(s) of the selected object(s)...          	     ] card script Dw on mouseUp
  edit script of this cd of the topStack
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Edit script of the current card..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
         @    horizontal  375,53	vertikal  32,407 #Edit script of the current card...          	     ^ 
stack script Dw on mouseUp
  edit script of the topStack
end mouseUp

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Edit script of the top-stack..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
         @    horizontal  439,53	vertikal  32,420  Edit script of the top-stack...          	     _ gocd ¶	uon menuPick was
  set the defaultstack to the topstack
  if the altkey = "down" then lock messages
  if there is a card was then go cd was
end menuPick

on mouseenter
  repeat with i = 1 to the num of cds of the topstack
    put the short name of cd i of the topstack & CR after neu
  end repeat
  delete char -1 of neu
  put the short name of the topstack into tps
  
  put "(Stack:" && tps & CR & "-" & CR & neu into me
  
  if the tp of this stack is "1" then
    set the tooltip of me to "Go to a specific card in stack " & QUOTE & the short name of the topstack & QUOTE & ". Press ALT to lock messages..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
         T @    	vertikal  32,91horizontal  173,53 PGo to a specific card in stack "Control Browser". Press ALT to lock messages...                    go card...         '(Stack: Control Browser
-
card id 1002       	   	     
  ` 
dndscript  !`     @p   	vertikal  120,208horizontal  120,208         8# Drag and Drop routines by Klaus major, www.major-k.de  #  2004, major-k    
# Enjoy! :-)    +# But consider to eventually comment these  .# scripts out before building a standalone...  8# ONLY in case you don't need it in your standalone ;-)    
on dragenter    set the acceptdrop to true  end dragenter    on dragdrop  &  put line 1 of the dragdata into ddd  0  put tolower(char -5 to -1 of ddd) into endung      8  if char 1 of endung = "." then put endung into endung  H  if char 2 of endung = "." then put char 2 to -1 of endung into endung  H  if char 3 of endung = "." then put char 3 to -1 of endung into endung        switch endung    case ".gif"    case ".giff"    case ".jpg"    case ".jpeg"    case ".png"    case ".bmp"  (    if the target contains "image" then  "      if the altkey = "down" then  2        put url("binfile:" & ddd) into the target        else  .        set the filename of the target to ddd  
      end if      end if  
    break    case ".tif"    case ".tiff"    case ".psd"    case ".tga"  ,    if the char 1 of the qtversion >=5 then  +      if the target contains "player" then  .        set the filename of the target to ddd  
      end if  	    else        beep  N      answer "You need QuickTime version >= 5 installed to use this feature!"        exit switch      end if  
    break    case ".txt"  O    if the target contains "field" then put url("file:" & ddd) into the target  
    break    case ".html"    case ".htm"  \    if the target contains "field" then set the htmltext of the target to url("file:" & dd)  
    break    case ".rtf"  \    if the target contains "field" then set the rtftext of the target to url("file:" & ddd)  
    break    case ".avi"    case ".mpg"    case ".mpeg"    case ".wav"    case ".aif"  
  case ".au"  )    if the target contains "player" then  ,      set the filename of the target to ddd      end if  
    break    case ".mov"    case ".swf"  
  case ".au"  
  case ".dv"  ,    if the char 1 of the qtversion >=5 then  +      if the target contains "player" then  .        set the filename of the target to ddd  
      end if  	    else        beep  N      answer "You need QuickTime version >= 5 installed to use this feature!"        exit switch      end if  
    break    case ".pdf"  T    if the platform contains "Mac" AND char 1 to 2 of the systemversion = "10" then  +      if the target contains "player" then  .        set the filename of the target to ddd  
      end if  	    else        beep      end if  
    break  
  end switch  
end dragdrop    =## Thanks to Richard Gaskin for this little handy sucker :-)    on IfX pIt  R  if pIt = empty or pIt = "Cancel" or the result = "cancel" then exit to metacard  end IfX   a    	`    @      mpf  	@           horizontal  275,261	vertikal  275,258  VGIF89a    f3 f̙3̙ ffЙff33f̙  3fff̙3f33̙3f  f̙ ff3ff̙3 ̙333f̙̙   3 f3ff̙f ff̠3f3̙3 3f3̙f ̙   ff fff3ffff3 ̙333fff  ̙ 3 3f3ffff f3̙f3̀f3f3 33|||f3f f   ff3 3fff3f3̀ ff 33pppf3333ff3  f  3 33f3ffff f ddd33fff333 3 33f3 ff     f3 f fXXX3f3ff f3 3 f̙333f3f3    f3 LLL  3f  33 ff3f ff 33 3f33 f3@@@ 33  f3  f f  3 f33ff  3444 3 333f  3  33 3 f f 3f(((  3 f 3 333 f   3   3 f  3 3  3      f  3                           !  r ,       3 H*\ȰÄ"J?O3zxF=ndxBS$ ;        b Icons   on mouseUp
  local ostacks, nstacks
  put the openStacks into ostacks
  if "My Icons" is not in ostacks and "My Patterns" is not in ostacks then
    put the number of lines in ostacks into nstacks
    repeat with i = 1 to nstacks
      if the mode of stack (line i of ostacks) is 5 then
        beep 1
        newtool
        exit to MetaCard
      end if
    end repeat
  end if
  if (word 1 of the name of the target is "button") AND (the owner of the target is me) then
    if the short name of the target is in "pointer browse button field scrollbar image player"
    then choose (the short name of the target) tool
    else
      set the style of the templateGraphic to the short name of the target
      set the points of the templateGraphic to empty
      set the markerPoints of the templateGraphic to empty
      choose graphic tool
    end if
    send "changeTool" to stack "Paint Tools"
    send "changeTool" to stack "2lz3"
    send "changeTool" to stack "MetaCard Menu Bar"
  end if
end mouseUp

on mouseenter
  if the owner of the target is not me then exit mouseenter
  if the tp of this stack = 1 then
    set the tooltip of the target to (the short name of the target && "tool")
  else
    set the tooltip of the target to empty
  end if
end mouseenter

on newTool
end newTool
       _    horizontal  502,16	vertikal  128,195  c browse B4~on mouseUp which
  if which is 3 then
    set the customKeys of stack "Home" to empty
    set the mcvendor of stack "Home" to the "MetaCard Corporation"
    set the mcversion of stack "MetaCard Menu Bar" to the version
    set the mcversion of stack "Help Directory" to the version
    put empty into field "File Name" of card 2 of stack "Importer"
    put empty into field "Find" of stack "Find"
    put empty into field "Find Text" of stack "Script Find"
    put empty into field "Replace Text" of stack "Script Find"
    put empty into field "Name" of stack "Order Forms"
    put empty into field "Organization" of stack "Order Forms"
    put empty into field "Licenses" of card 1 of stack "Order Forms"
    put empty into field "Key" of card 1 of stack "Order Forms"
    toplevel "Script Editor"
    set the width of stack "Script Editor" to 600
    set the height of stack "Script Editor" to 450
    close stack "Script Editor"
    choose browse tool
    go "Properties"
    repeat with i = 1 to the number of cards in this stack
      go to card i
      click at 7,7
    end repeat
    close stack "Properties"
  else pass mouseUp
end mouseUp
         c       horizontal  295,16	vertikal  16,115 browse tool               .            	    d pointer B$        c       horizontal  327,16	vertikal  48,115 
pointer tool               -            	     e button B$               horizontal  359,16	vertikal  16,147 button tool               /            	     f field B$               horizontal  391,16	vertikal  48,147 field tool               0            	     g 
scrollbar B$               horizontal  423,16	vertikal  16,179 scrollbar tool               1            	     h image B$               horizontal  455,16	vertikal  48,179 image tool               _            	     i player B$               horizontal  487,16	vertikal  16,211 player tool                           	     j line B$               horizontal  519,16	vertikal  48,211 
line tool               N            	     k polygon B$               horizontal  551,16	vertikal  16,243 
polygon tool               =            	     l curve B$               horizontal  582,16	vertikal  48,243 curve tool               :            	     m 
rectangle B$              horizontal  614,16	vertikal  16,275 rectangle tool               <            	     n oval B$              horizontal  646,16	vertikal  48,275 
oval tool               9            	     o 
roundrect B$              horizontal  678,16	vertikal  208,211 roundrect tool               >            	     p regular B$              horizontal  710,16	vertikal  240,211 
regular tool               ;            	     r xclosehoriz1.jpg @      '      horizontal  49,32	vertikal  49,32   JFIF   d d   Ducky     d   Adobe d                      	
            	 
 	u!" 1A2#	QBa$3Rqb%C&4r
5'S6DTsEF7Gc(UVWdte)8fu*9:HIJXYZghijvwxyz m!1 "AQ2aqB#Rb3	$Cr4%ScD&5T6Ed'
sFtUeuV7)(GWf8vgwHXhx9IYiy*:JZjz   ? ګ7|v]=u5[j}jw=ڸrr٬aew,⮖ZKIEY){W]=Ӹ߽iz tw~A&iQc3՝uY]4xgO7V q/ߺE3['[W6z<[p+wb- җvl8(2~*ej-1L0^,L'n쾤ܿ/7={1}29{)ewZԣi&;0v34hW{Uj 3' Z}u        s xclosehoriz2.jpg @           horizontal  32,287	vertikal  32,287   JFIF   d d   Ducky     d   Adobe d                      	
            	 
 	u!" 1A2#	QBa$3Rqb%C&4r
5'S6DTsEF7Gc(UVWdte)8fu*9:HIJXYZghijvwxyz m!1 "AQ2aqB#Rb3	$Cr4%ScD&5T6Ed'
sFtUeuV7)(GWf8vgwHXhx9IYiy*:JZjz   ? #_6'Uaza3}ݛmGFc%kv,F=\.KqF-St {זv*UKԩ{ܷjFW%T}c~TwQnY_tugye{ ktԛgo|-]nmQ|
u]U<i<sCP`߾24JJR u 9"睿xZʈ2h젏 ٿ _Y?N۝XwKuGpYzbnsfM{n
Ȧ2pPWk!c,qZPQ]Cc;_u(d*Ti4iVJ>?r6~ sKgY	g-Hꁴ +@":_Q]/^H'>Y\}]2D9,K7^HIvr2+ g6Ud42ơwEbFO +@*z>`䛍sط-ZtY-<(X8!(S1 u{^J_d O#_        q dragwindow   Kpon mouseDown
  global gAllowDrag
  put mouseH() & "," & mouseV() into gAllowDrag
end mouseDown

on mouseMove
  global gAllowDrag
  if the mouse is "up" then
    put empty into gAllowDrag
    pass mouseMove
  end if
  if gAllowDrag is not empty then
    set the topLeft of this stack to \
        item 1 of the screenMouseLoc - item 1 of gAllowDrag,\
        item 2 of the screenMouseLoc - item 2 of gAllowDrag
  end if
  pass mouseMove
end mouseMove

on mouseUp
  global gAllowDrag
  put empty into gAllowDrag
end mouseUp
       H M   	vertikal  32,37horizontal  32,37     = Misc... ¶	uFon menuPick was
  switch was
  case "Help..."
    modeless "2lz3 help"
    break
  case "Preferences..."
    go stack "2lz3 prefs" as sheet
    break
  case "Vertical"
    machvertikal
    #  set the top of this stack to 38
    # set the left of this stack to 0
    break
  case "Horizontal"
    machhorizontal
    break
  case "Import..."
    palette "importer"
    break
  case "Set directory..."
    answer folder "Please select a directory:"
    if the result = "cancel" then exit menupick
    set the directory to it
    break
  case "Answer file..."
    answer file "Please select a file:"
    if the result = "cancel" then exit menupick
    set clipboarddata["text"] to it
    put it
    break
    
  case "Analyze it..."
    palette "Analyze it..."
    break
  case "Favourites..."
    palette "Favourites"
    break
  case "Einstein..."
    palette "einstein"
    break
  end switch
end menuPick

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Some useful menu-items..."
  else
    set the tooltip of me to empty
  end if
  scheckung
end mouseenter
          @    horizontal  47,39	vertikal  32,22 Some useful menu-items...                    misc...         Help...
-
Preferences...
-
(Orientation:
-
Horizontal
Vertical
-
(File and folder ops:
-
Import...
-
Set directory...
Answer file...
-
(Tools:
-
Analyze it...
Favourites...
Einstein...       	   	       - aktion ¶	u## You can easily add your own scripts here...
## As you can see the menuitems are just called by their line-number in the button.
## So add your script, keep on counting and there you go :-)

## I inserted the script of btn "dertrigger" on this cd.
## There the "ESC"-key messages is handled and passed...

## I thought this to be a very useful feature to me :-)
## Saves some typing in the messagebox...

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Send a useful command in 2 seconds :-) Press ESC to cancel..."
  else
    set the tooltip of me to empty
  end if
end mouseenter

on mitstack
  if the mousestack = empty then
    beep
    exit to metacard
  end if
end mitstack

on menupick was
  mitstack
  send ("action" & word 1 of was) to me in 2 secs
end menupick

on action1
  mitstack
  toplevel the mousestack
end action1

on action2
  mitstack
  palette the mousestack
end action2

on action3
  mitstack
  modeless the mousestack
end action3

on action4
  mitstack
  set the loc of the mousestack to the screenloc
end action4

on action7
  mitstack
  edit script of the mousestack
end action7

on action5
  mitstack
  edit script of the mousecontrol
end action5

on action6
  mitstack
  edit script of this card of the mousestack
end action6

on action8
  mitstack
  save the mousestack
end action8

on action9
  mitstack
  lock messages
  close the mousestack
end action9

on action10
  mitstack
  lock messages
  clone the mousestack
end action10
          @    	vertikal  32,36horizontal  47,53 >Send a useful command in 2 seconds :-) Press ESC to cancel...                    actions...        ?1 toplevel the mousestack
2 palette the mousestack
3 modeless the mousestack
-
4 set the loc of the mousestack to the screenloc
-
5 edit script of the mousecontrol
6 edit script of current card of the mousestack
7 edit script of the mousestack
-
8 save the mousestack
-
9 close the mousestack
-
10 clone the mousestack       	     u pinstripe.gif @         > ,   	vertikal  32,22horizontal  32,22   GIF89a> ,      !     ,    > ,  }+ڋ
Hډö.rZ]N	u6LfB	Ojqjخ
zk
qhh_<
Cʺė7xa8DH(88xS  ;       cREVGeneral    revUniqueID  
1090929391922   index dw on mouseup
  modeless "Help Index"
end mouseup

on mouseenter
  if the tp of this stack is "1" then
    set the tooltip of me to "Will open the MC help index..."
  else
    set the tooltip of me to empty
  end if
end mouseenter
        # @    	vertikal  32,298horizontal  567,39 Will open the MC help index...  index          	     t close C on mouseUp
  set the icon of me to 1138
  close this stack
end mouseUp

on mouseenter
  set the icon of me to 1139
end mouseenter

on mouseleave
  set the icon of me to 1138
end mouseleave

on mouserelease
  set the icon of me to 1138
end mouserelease
             horizontal  8,7	vertikal  8,7              r             	     
   dasding  )8  on mouseenter
  scheckung
  if fld "dasding" is empty then
    set the tooltip of me to empty
    exit mouseenter
  end if
  if the tp of this stack <> 1 then
    exit mouseenter
  end if
  set the tooltip of me to "selobj: " & fld "dasding"
end mouseenter

on tabkey
  ##
end tabkey
     @   @ !   horizontal  110,16	vertikal  32,443 Zselobj: button id 1224 of card id 1001 of stack "C:/Programme/MetaCard/Program/mchome.mc"               w revfake Epgfunction revDirectoryWalking pFolder
  if there is not a folder pFolder then
    if there is a file pFolder then
      return pFolder
    else
      return empty
    end if
  else
    set the defaultFolder to pFolder
    put the detailed files into tList
    repeat for each line i in tList
      put pFolder & "/" & i & cr after tFilesList
    end repeat
    put the folders into tDirList
    repeat with i = 2 to the number of lines of tDirList
      put revDirectoryWalking (pFolder & "/" & (line i of tDirList)) after tFilesList
    end repeat
    return tFilesList
  end if
end revDirectoryWalking

function revDirWalker pFolder
  put the defaultFolder into tDefaultFolder
  put revDirectoryWalking(pFolder) into tList
  set the defaultFolder to tDefaultFolder
  return tList
end revDirWalker

on revCompress pFolder, pSavePath, pName
  put the fileType into tFileType
  if the paramcount is 0 then
    return "No parameters entered"
    exit revCompress
  end if
  set the itemDelimiter to "/"
  put item -1 of pFolder into tFolderName
  put revdirWalker(pFolder) into tDetailedFileList
  if tDetailedFileList is empty then exit revCompress
  set the itemDelimiter to comma
  repeat for each line i in tDetailedFileList
    put URLDecode( item 1 of i) & cr after tFileList
  end repeat
  set the itemDelimiter to "/"
  repeat for each line i in tFileList
    put itemOffset(tFolderName,i) into tOffset
    put item tOffset to -1 of i & cr after tList
  end repeat
  if (the paramcount is 1) or (the paramcount is 2) then
    put tFolderName & ".dir" into tStackName
  else
    put pName & ".dir" into tStackName
  end if
  
  create stack tStackName
  set the cSourcePlatform of stack tStackName to the platform
  set the cSourceFolderName of stack tStackName to tFolderName
  set the cSourceFilesList of stack tStackName to tFileList
  set the cFilesList of stack tStackName to tList
  repeat with i = 1 to the number of lines in tFileList
    set the cBinFile[line i of tList] of stack tStackName to URL ("binfile:" & line i of tFileList)
    set the cResFile[line i of tList] of stack tStackName to URL ("resfile:" & line i of tFileList)
    if the platform is "MacOS" then
      set the itemDelimiter to comma
      put item 11 of line i of tDetailedFileList into tType
      if tType is empty then
        set the cFileType[line i of tList] of stack tStackName to "        "
      else
        set the cFileType[line i of tList] of stack tStackName to tType
      end if
      set the itemDelimiter to "/"
    end if
  end repeat
  
  if the paramcount is 1 then
    put the defaultFolder & "/" & tStackName into tSavePath
  else
    if the last char of pSavePath is "/" then delete the last char of pSavePath
    put pSavePath & "/" & tStackName into tSavePath
  end if
  save stack tStackName as tSavePath
  put compress(URL ("binfile:" & tSavePath)) into URL ("binfile:" & tSavePath & ".gz")
  delete file tSavePath
  close stack tStackName
  delete stack tStackName
  set the fileType to tFileType
  return empty
end revCompress

on revDecompress pFile, pFolder
  put the fileType into tFileType
  put pFile into tFile
  if char -7 to -1 of tFile is ".dir.gz" then
    delete char -3 to -1 of tFile
  else
    exit revDecompress
  end if
  try
    put decompress(URL ("binfile:" & pFile)) into URL ("binfile:" & tFile)
    if the result is not empty then throw the result
  catch tError
    return "Invalid file type"
    exit revDecompress
  end try
  if the last char of pFolder is "/" then delete the last char of pFolder
  open stack tFile
  put the short name of this stack into tName
  put the cFilesList of stack tName into tFilesList
  put the cSourceFolderName of stack tName into tFolderName
  put the cSourcePlatform of stack tName into tPlatform
  if the paramcount is 1 then
    put the defaultFolder into pFolder
  end if
  repeat for each line i in tFilesList
    put i into tDirPath
    set the itemDelimiter to "/"
    delete the last item of tDirPath
    put pFolder & "/" & tDirPath into tFolderPath
    put itemOffset(tFolderName,tFolderPath) into tOffset
    put the number of items in tFolderPath into tItems
    repeat with j = tOffset to tItems
      put item 1 to j of tFolderPath into tCreateFolder
      if there is not a folder tCreateFolder then create folder tCreateFolder
    end repeat
    if tPlatform is "MacOS" then
      set the fileType to the cFileType[i] of stack tName
    end if
    put the cBinFile[i] of stack tName into URL ("binfile:" & pFolder & "/" & i)
    put the cResFile[i] of stack tName into URL ("resfile:" & pFolder & "/" & i)
  end repeat
  delete file tFile
  close stack tName
  delete stack tName
  set the fileType to tFileType
  return empty
end revDecompress

on revGoURL pWhich
  global gREVWebBrowser
  revSetWindowsShellCommand
  put revRunningWindowsNT() into tNT
  if "file://" is not in pWhich then replace "file:/" with "file:///" in pWhich--so that local URLs as used in Transcript can be used
  if the platform is "Win32" then
    if char 1 to 7 of pWhich is "mailto:" then
      put queryRegistry("HKEY_CLASSES_ROOT\mailto\shell\open\command\") into tMailApp
      replace quote & "%1" & quote with pWhich in tMailApp
      replace "%1" with pWhich in tMailApp
      
      --older versions use %l ("pecent L")
      replace quote & "%l" & quote with pWhich in tMailApp
      replace "%l" with pWhich in tMailApp
      
      -- for the new and wonderful XP
      replace "%ProgramFiles%" with $ProgramFiles in tMailApp
      
      open process tMailApp for neither
    else
      put word 1 of queryRegistry("hkey_local_machine\software\classes\http\shell\open\command\") into tWebBrowserPath
      if not tNT then
        get shell(tWebBrowserPath && quote & pWhich & quote)
      else
        set the hideconsolewindows to false
        open process (tWebBrowserPath && quote & pWhich & quote) for neither
      end if
    end if
  else if the platform is "MacOS" then
    if "appleScript" is not in the alternateLanguages then
      return "Error: AppleScript not installed"
    end if
    do ("open location" && quote & pWhich & quote) as appleScript
  else
    if gREVWebBrowser is empty
    then launch "mozilla" && quote & pWhich & quote
    else launch gREVWebBrowser && quote & pWhich & quote
  end if
end revGoURL

on revMail pTo, pCC, pSubject, pBody
  local tURL
  put empty into tURL
  if the paramcount is 1 then
    put "mailto:" & pTo into tURL
  else
    if pCC is not empty then put true into tCC
    if pSubject is not empty then put true into tSubject
    if pBody is not empty then put true into tBody
    
    put "mailto:" & pTo into tURL
    if tCC then
      if (tURL contains "?Subject=") or (tURL contains "?Body=") then
        put "&" & "CC=" & pCC after tURL
      else
        put "?" & "CC=" & pCC after tURL
      end if
    end if
    if tSubject then
      if (tURL contains "?CC=") or (tURL contains "?Body=") then
        put "&" & "Subject=" & pSubject after tURL
      else
        put "?" & "Subject=" & pSubject after tURL
      end if
    end if
    if tBody then
      if (tURL contains "?CC=") or (tURL contains "?Subject=") then
        put "&" & "Body=" & pBody after tURL
      else
        put "?" & "Body=" & pBody after tURL
      end if
    end if
  end if
  revGoURL tURL
end revMail

function revRunningWindowsNT
  if the platform is not "Win32" then return false
  if word 1 of the systemVersion is "Windows"
  then return false
  else return true
end revRunningWindowsNT

on revSetWindowsShellCommand
  if the platform is not "Win32" then exit revSetWindowsShellCommand
  set the hideConsoleWindows to true
  if $COMSPEC is not empty then set the shellCommand to $COMSPEC
  else
    --just in case some windows versions don't use $COMSPEC
    if revRunningWindowsNT() then set the shellCommand to "cmd.exe"
    else set the shellCommand to "command.com"
  end if
end revSetWindowsShellCommand

--Path Conversion Functions

function revUnixFromMacPath thePath,assumeOSX
  local numberOfLevels
  if assumeOSX is empty then -- set default based on current OS
    set the itemDelimiter to "."
    if the platform is "MacOS" and item 1 of the systemVersion is "10"
    then put true into assumeOSX
    else put false into assumeOSX
  end if
  
  if char 1 of thePath is colon then -- relative path
    repeat while char 1 of thePath is colon
      delete char 1 of thePath
      add 1 to numberOfLevels -- keep track
    end repeat
    if numberOfLevels is 1 then
      put ".:" before thePath
    else -- more than one level
      repeat for (numberOfLevels - 1) times
        put "..:" before thePath
      end repeat
    end if
  else -- colon is not char 1 - therefore it's an absolute path
    set the itemDelimiter to colon
    if assumeOSX then
      if line 1 of the drives is item 1 of thePath then delete item 1 of thePath -- startup drive
      else put "Volumes:" before thePath -- non-startup drives are rooted in the Volumes dir on OS X
    end if
    put colon before thePath -- will be transformed to slash
  end if
  
  replace colon with linefeed in thePath
  replace "/" with colon in thePath
  replace linefeed with "/" in thePath
  return thePath
end revUnixFromMacPath

function revMacFromUnixPath thePath,assumeOSX
  local numberOfLevels
  if assumeOSX is empty then -- set default based on current OS
    set the itemDelimiter to "."
    if the platform is "MacOS" and item 1 of the systemVersion is "10"
    then put true into assumeOSX
    else put false into assumeOSX
  end if
  
  replace colon with linefeed in thePath
  if char 1 of thePath is "/" then delete char 1 of thePath
  replace "/" with colon in thePath
  replace linefeed with "/" in thePath
  if char 1 to 2 of thePath is ".:" then delete char 1 of thePath
  else if char 1 to 3 of thePath is "..:" then -- relative path
    repeat while char 1 to 3 of thePath is "..:"
      delete char 1 to 3 of thePath
      add 1 to numberOfLevels
    end repeat
    repeat for numberOfLevels + 1 times
      put ":" before thePath
    end repeat
  end if
  
  if char 1 of thePath is not ":" and assumeOSX then
    -- it's an absolute path, so adjust for OS X if necessary
    set the itemDelimiter to ":"
    if item 1 of thePath is "Volumes" then delete item 1 of thePath -- non-startup disk
    else put line 1 of the drives & ":" before thePath -- need to prepend startup disk name
  end if
  return thePath
end revMacFromUnixPath

--File transfer functions
function revWindowsFromUnixPath pUnixPath
  replace "/" with "\" in pUnixPath
  return pUnixPath
end revWindowsFromUnixPath

on revCopyFile pSrcFile, pDestFile
  if the platform is "MacOS" and char 1 of the systemVersion is not "1" then
    if "applescript" is in the alternateLanguages then
      do revAppleScriptFull("copyFile",pSrcFile,pDestFile) as applescript
    else return "Error: AppleScript not installed"
  else if the platform is "Win32" then
    revSetWindowsShellCommand
    if there is a directory pDestFile then
      set the itemDel to "/"
      if char -1 of pDestFile is "/" then delete char -1 of pDestFile
      put item -1 of pSrcFile into tDestFileName
      set the itemDel to comma
      put "/" & tDestFileName after pDestFile
    end if
    get shell ("copy" && revWindowsFromUnixPath(quote&pSrcFile&quote) && revWindowsFromUnixPath(quote&pDestFile&quote))
  else
    get shell ("cp -f" && quote&pSrcFile&quote && quote&pDestFile&quote)
  end if
  return the result
end revCopyFile

on revCopyFolder pSrcFolder, pDestFolder
  if the platform is "MacOS" and char 1 of the systemVersion is not "1" then
    if "applescript" is in the alternateLanguages then
      if there is not a folder pDestFolder then
        create folder pDestFolder
      end if
      do revAppleScriptFull("copyFolder",pSrcFolder,pDestFolder) as applescript
    else return "Error: AppleScript not installed"
  else if the platform is "Win32" then
    revSetWindowsShellCommand
    if there is a directory pDestFolder then
      set the itemDel to "/"
      if char -1 of pDestFolder is "/" then delete char -1 of pDestFolder
      put item -1 of pSrcFolder into tLastItemofSrcFolder
      put "/" & tLastItemofSrcFolder after pDestFolder
      create directory pDestFolder
    end if
    get shell ("xcopy /I /E" && revWindowsFromUnixPath(quote&pSrcFolder&quote) && revWindowsFromUnixPath(quote&pDestFolder&quote))
  else
    get shell ("cp -rf" && quote&pSrcFolder&quote && quote&pDestFolder&quote)
  end if
  return the result
end revCopyFolder

on revCopyPackage pSrcFolder, pDestFolder
  if the platform is "MacOS" and char 1 of the systemVersion is not "1" then
    if "applescript" is in the alternateLanguages then
      if there is not a folder pDestFolder then
        create folder pDestFolder
      end if
      do revAppleScriptFull("copyPackage",pSrcFolder,pDestFolder) as applescript
    else return "Error: AppleScript not installed"
  else if the platform is "Win32" then
    revSetWindowsShellCommand
    if there is a directory pDestFolder then
      set the itemDel to "/"
      if char -1 of pDestFolder is "/" then delete char -1 of pDestFolder
      put item -1 of pSrcFolder into tLastItemofSrcFolder
      put "/" & tLastItemofSrcFolder after pDestFolder
      create directory pDestFolder
    end if
    get shell ("xcopy /I /E" && revWindowsFromUnixPath(quote&pSrcFolder&quote) && revWindowsFromUnixPath(quote&pDestFolder&quote))
  else
    get shell ("cp -rf" && quote&pSrcFolder&quote && quote&pDestFolder&quote)
  end if
  return the result
end revCopyPackage

on revDeleteFolder pSrcFolder
  if the platform is "MacOS" and char 1 of the systemVersion is not "1" then
    if "applescript" is in the alternateLanguages then
      do revAppleScriptFull("deleteFolder",pSrcFolder,pDestFolder) as applescript
    else return "Error: AppleScript not installed"
  else if the platform is "Win32" then
    revSetWindowsShellCommand
    -- check for Win 2000 and XP
    if char 1 of word 2 of the systemVersion is "5" then
      get shell ("rmdir /s /q" && revWindowsFromUnixPath(quote&pSrcFolder&quote))
    else
      get shell ("deltree /Y" && revWindowsFromUnixPath(quote&pSrcFolder&quote))
    end if
  else
    get shell ("rm -rf" && quote&pSrcFolder&quote)
  end if
  return the result
end revDeleteFolder

on revMoveFolder pSrcFolder, pDestFolder
  if the platform is "MacOS" and char 1 of the systemVersion is not "1" then
    if "applescript" is in the alternateLanguages then
      do revAppleScriptFull("moveFolder",pSrcFolder,pDestFolder) as applescript
    else return "Error: AppleScript not installed"
  else if the platform is "Win32" then
    revSetWindowsShellCommand
    get shell ("move /Y" && revWindowsFromUnixPath(quote&pSrcFolder&quote) && revWindowsFromUnixPath(quote&pDestFolder&quote))
  else
    get shell ("mv -f" && quote&pSrcFolder&quote && quote&pDestFolder&quote)
  end if
  return the result
end revMoveFolder

on IfX pIt
  if pIt = empty or pIt = "Cancel" or the result = "cancel" then exit to metacard
end IfX

function revPathtoApplescript pPath
  put empty into tApplescript
  replace "\" with "\\" in pPath
  replace quote with "\" & quote in pPath
  put quote & revMacFromUnixPath(pPath) & quote into tApplescript
  return tApplescript
end revPathtoApplescript

function revApplescriptFull pfunction,pSrc,pDest
  switch pfunction
  case "deleteFolder"
    put "tell application" && quote & "Finder" & quote & cr & tab & "delete folder" && revPathtoApplescript(pSrc) && cr & "end tell" into tApplescriptfull
    exit switch
  case "copyFolder"
    put "tell application" && quote & "Finder" & quote & cr & tab & "copy folder" && revPathtoApplescript(pSrc) && "to folder" && revPathtoApplescript(pDest) && cr & "end tell" into tApplescriptfull
    exit switch
  case "copyPackage"
    put "tell application" && quote & "Finder" & quote & cr & tab & "copy package" && revPathtoApplescript(pSrc) && "to folder" && revPathtoApplescript(pDest) && cr & "end tell" into tApplescriptfull
    exit switch
  case "copyFile"
    put "tell application" && quote & "Finder" & quote & cr & tab & "copy file" && revPathtoApplescript(pSrc) && "to folder" && revPathtoApplescript(pDest) && cr & "end tell" into tApplescriptfull
    exit switch
  case "moveFolder"
    put "tell application" && quote & "Finder" & quote & cr & tab & "move folder" && revPathtoApplescript(pSrc) && "to folder" && revPathtoApplescript(pDest) && cr & "end tell" into tApplescriptfull
    exit switch
  end switch
  return tApplescriptfull
end revApplescriptFull


----------------------printing handlers
local lPageNumber, pageNumber --holds lPageNumber between handlers
local lAnswerPrinter, lPageSetup
local numPages
constant kPo = 36

on revShowPrintDialog pAnswerPrinter, pMacPrinter
  --pAnswerPrinter governs whether to show number of copies / etc. box
  --pAnswerPrinter covers page setup on Windows as these are the same dialog
  --pMacPrinter governs whether to show Mac printer box (MacOS only)
  put pAnswerPrinter into lAnswerPrinter
  put pMacPrinter into lPageSetup
end revShowPrintDialog

on revPrintField pFieldRef
  --just takes a field reference and prints the field, complete with styles and no fuss
  --if not (there is a fld pFieldRef) then do "put the short name of" && pFieldRef && "into pFieldRef"
  revPrintText the htmlText of pFieldRef,empty,empty,the long id of pFieldRef
end revPrintField

on revPrintText pText,pHeader,pFooter,pSourceFieldRef,pHeaderFldRef,pFooterFldRef
  --pText contains the text, either html or text
  --pHeader contains header text, either html or text
  --pFooter contains header text, either html or text
  --pSourceFieldRef contains a vaild field descriptor
  local tActualPageWidth --width of page subtracting right and left printmargins
  local tPrintMargins --margins stored in array for script simplification
  local tPageWidth,tPageHeight --height and width of the page
  local tScrolling,tPageLine,tScrollList --scroll values for text height calculations
  lock messages
  --General Initialization
  if lAnswerPrinter then answer printer
  if the result is "Cancel" then
    return "cancel"
  end if
  if lPageSetup then
    open printing with dialog
    if the result is "cancel" then
      --close printing--prints blank page
      return "cancel"
    end if
  else
    open printing
  end if
  if pSourceFieldRef <> "" and pHeaderFldRef = "" then put pSourceFieldRef into pHeaderFldRef
  if pSourceFieldRef <> "" and pFooterFldRef = "" then put pSourceFieldRef into pFooterFldRef
  put item 1 of the printmargins into tPrintMargins["left"]
  put item 2 of the printmargins into tPrintMargins["top"]
  put item 3 of the printmargins into tPrintMargins["right"]
  put item 4 of the printmargins into tPrintMargins["bottom"]
  put item 1 of the printpapersize into tPageWidth
  put item 2 of the printpapersize into tPageHeight
  put 0 into tScrolling
  put 0 into tPageLine
  put 1 into lPageNumber
  put lPageNumber into pageNumber
  put tPageWidth -tPrintMargins["right"]-tPrintMargins["left"] into tActualPageWidth
  -- prepare template for invisible stacks the width of the page
  set the backgroundcolor of the templateStack to "white"
  if pSourceFieldRef is not empty then
    put revTargetStack(pSourceFieldRef) into tTargetStack
    set the underLineLinks of the templateStack to the underLineLinks of stack tTargetStack
    set the linkColor of the templateStack to the linkColor of stack tTargetStack
    set the linkHiliteColor of the templateStack to the linkHiliteColor of stack tTargetStack
    set the linkVisitedColor of the templateStack to the linkVisitedColor of stack tTargetStack
  end if
  set the visible of the templateStack to false
  set the width of the templateStack to tActualPageWidth
  set formatforprinting of the templateStack to false--test
  set formatforprinting of the templateStack to true
  -- prepare template for fields in these stacks
  set the width of the templateField to tActualPageWidth
  -- the following three properties are set so that text height calculations are correct
  set the borderwidth of the templateField to 0
  set the margins of the templateField to 6
  set the showborder of the templateField to true
  set the opaque of the templateField to false
  set the fixedLineHeight of the templateField to false
  set the lockLoc of the templateField to true
  -- Header and Footer initialization
  if pHeader is not empty then
    create stack "revTempHeader"
    set the defaultStack to "revTempHeader"
    revSetPrintFont pHeaderFldRef
    get revCreatePrintHeaderAndFooter(pHeader)
    -- if size of header or footer is greater then current margins will allow, then
    -- increase top or bottom margins.
    if it > tPrintMargins["top"] then put it into tPrintMargins["top"]
  end if
  if pFooter is not empty then
    create stack "revTempFooter"
    set the defaultStack to "revTempFooter"
    revSetPrintFont pFooterFldRef
    get revCreatePrintHeaderAndFooter(pFooter)
    if it>tPrintMargins["bottom"] then put it into tPrintMargins["bottom"]
  end if
  
  --Body initialization
  --set height of the templateStack to tPageHeight - tPrintMargins["bottom"] - tPrintMargins["top"]
  create stack "revTempBody"
  set the defaultStack to "revTempBody"
  set height of this stack to tPageHeight - tPrintMargins["bottom"] - tPrintMargins["top"]
  revSetPrintFont pSourceFieldRef
  create field
  if pSourceFieldRef is not empty then
    set the tabStops of field 1 to the tabStops of pSourceFieldRef
    set the hGrid of field 1 to the hGrid of pSourceFieldRef
    set the vGrid of field 1 to the vGrid of pSourceFieldRef
    set the fixedLineHeight of field 1 to the fixedLineHeight of pSourceFieldRef -- NEW
    set the textHeight of field 1 to the effective textHeight of pSourceFieldRef -- NEW
  end if
  set the rect of field 1 to rect of this card
  revPrintSetText pText
  put the pageheights of field 1 into tScrollList
  --Printing Cycle
  -- headers and footers are split up into three fields by tab items
  set the itemDel to tab
  put the number of lines of tScrollList into numPages
  repeat
    If pHeader is not empty then
      set the defaultStack to "revTempHeader"
      repeat with lLoop = 1 to 3
        put item lLoop of pHeader into field lLoop
        if field lLoop <> empty then revPrintSetText field lLoop,lLoop
      end repeat
      print this card into tPrintMargins["left"],kPo,tPageWidth-tPrintMargins["right"],kPo+the height of stack "revTempHeader"
    end if
    If pFooter is not empty then
      set the defaultStack to "revTempFooter"
      repeat with lLoop = 1 to 3
        put item lLoop of pFooter into field lLoop
        if field lLoop <> empty then revPrintSetText field lLoop,lLoop
      end repeat
      print this card into tPrintMargins["left"],tPageHeight-kPo-height of stack "revTempFooter",tPageWidth-tPrintMargins["right"],tPageHeight-kPo
    end if
    add 1 to tPageLine
    add 1 to lPageNumber
    put lPageNumber into pageNumber
    set the defaultStack to "revTempBody"
    set the height of fld 1 to line tPageLine of tScrollList
    set the scroll of fld 1 to tScrolling
    add line tPageLine of tScrollList to tScrolling
    print this card into tPrintMargins["left"],tPrintMargins["top"],tPageWidth-tPrintMargins["right"],tPageHeight - tPrintMargins["bottom"]
    if tPageLine is numPages then exit repeat
    print break
  end repeat
  -- clean up
  close printing
  if there is a stack "revTempHeader" then delete stack "revTempHeader"
  if there is a stack "revTempFooter" then delete stack "revTempFooter"
  delete stack "revTempBody"
  reset the templateStack
  reset the templateField
end revPrintText

on revPrintSetText pTheText, pFldNum
  local tExpressionStart, tExpressionEnd
  if pFldNum = "" then put 1 into pFldNum
  if "<p>" is in pTheText or matchChunk(pTheText, "<(.+>.+</.+)>") is true then set the htmltext of field pFldNum to pTheText
  else put pTheText into field pFldNum
  repeat until matchChunk(field pFldNum, "<%(.[^<]*)%>", tExpressionStart, tExpressionEnd) is false
    put value(char tExpressionStart to tExpressionEnd of field pFldNum) into char tExpressionStart-2 to tExpressionEnd+2 of field pFldNum
  end repeat
end revPrintSetText

-- Need to set the font after the stack is created to prevent inheritance of
-- non-formatForPrinting fonts from Home stack

on revSetPrintFont pSourceFieldRef
  if pSourceFieldRef is not empty then
    if the effective textFont of pSourceFieldRef is among the lines of fontNames("printer") then
      set the textFont of this stack to the effective textFont of pSourceFieldRef
    else
      if "Arial" is among the lines of fontNames("Printer") then set the textFont of this stack to "Arial"
      else if "Helvetica" is among the lines of fontNames("Printer") then set the textFont of this stack to "Helvetica"
      else set the textFont of this stack to line 1 of fontNames("printer")
    end if
    set the textSize of this stack to the effective textSize of pSourceFieldRef
    set the textStyle of this stack to the effective textStyle of pSourceFieldRef
  else
    set the textSize of this stack to 12
    if the effective textFont of this stack is not among the lines of fontNames("printer") then
      if "Arial" is among the lines of fontNames("printer") then set the textFont of this stack to "Arial"
      else if "Helvetica" is among the lines of fontNames("Printer") then set the textFont of this stack to "Helvetica"
      else set the textFont of this stack to line 1 of fontNames("printer")
    end if
  end if
end revSetPrintFont

function revCreatePrintHeaderAndFooter pTheText
  create field
  set the itemDelimiter to tab
  if item 1 of pTheText <> empty then
    revPrintSetText item 1 of pTheText,1
    put the formattedheight of field 1 into lFH1
  else put 0 into lFH1
  create field
  if item 2 of pTheText <> empty then
    revPrintSetText item 2 of pTheText,2
    put the formattedheight of field 2 into lFH2
  else put 0 into lFH2
  create field
  if item 3 of pTheText <> empty then
    revPrintSetText item 3 of pTheText,3
    put the formattedheight of field 3 into lFH3
  else put 0 into lFH3
  set the height of this stack to max(lFH1,lFH2,lFH3)
  get rect of this card
  set the rect of field 1 to it
  set the rect of field 2 to it
  set the rect of field 3 to it
  set the textalign of field 1 to left
  set the textalign of field 2 to "center"
  set the textalign of field 3 to right
  return height of this stack+kPo
end revCreatePrintHeaderAndFooter
       ~    horizontal  	1000,1000	vertikal  	1000,1000          cREVGeneral     	        Analyze it... "   on preopenstack
  set the loc of me to the screenloc
  set the style of this stack to palette
end preopenstack

on openstack
  ##
end openstack

on closestack
  ##
end closestack

on opencard
  ##
end opencard

on preopencard
  ##
end preopencard

on maches welcher
  
  set the defaultstack to welcher
  
  put the number of cds of stack welcher into anzcd
  
  put the number of bgs of stack welcher into anzbg
  
  put the number of cds of stack welcher into anzcd
  
  repeat with c = 1 to anzcd
    set cursor to busy
    put "Name:" & TAB & the short name of cd c & cr & "Nr:"  & TAB & c & CR & CR \
        & "Script:" & cr & CR & the script of cd c & CR  & cr & "**************************" & cr & cr after infocd
    
    put the number of grps of cd c into  anzgrp
    repeat with g = 1 to anzgrp
      put "On card: " & TAB & c & cr & "Groupname:" & TAB & the short name of grp g of cd c & \
          cr &"Nr.:" & TAB & g & cr & "ID:" & TAB & the id of grp g of cd c & cr \
          & "W/H:" & TAB & the width of grp g of cd c  & ", "  & the height of grp g of cd c & CR &\
          "Loc:" & TAB & the loc of grp g of cd c &  cr & "Visible:" & TAB & the vis of grp g of cd c & cr & cr & \
          "Script:" & cr & CR & the script of grp g of cd c & CR  & cr & "**************************" & CR & cr after infogrp
    end repeat
    
    put the number of btns of cd c into  anzbtn
    repeat with b = 1 to anzbtn
      put "On card: " & TAB & c & cr & "Buttonname:" & TAB & the short name of btn b of cd c &cr & \
          "Label:" & TAB & the label of btn b of cd c &\
          cr &"Nr.:" & TAB & b & cr & "ID:" & TAB & the id of btn b of cd c & cr \
          & "W/H:" & TAB & the width of btn b of cd c & ", "  & the height of btn b of cd c & CR &\
          "Loc:" & TAB & the loc of btn b of cd c & cr & "Owner:" & TAB & the owner of btn b of cd c & cr &\
          "Icon: " & TAB & the icon of btn b of cd c &cr & "Hiliteicon:" & TAB & the hiliteicon of btn b of cd c & CR & \
          "Style:" & TAB & the style of btn b of cd c &  CR & "Visible:" & TAB & the vis of btn b of cd c & cr\
          & cr & "Script:" & cr & cr & the script of btn b of cd c & CR  & cr & "**************************" & CR & cr after infobtn
    end repeat
    
    put the number of fields of cd c into  anzfld
    repeat with f = 1 to anzfld
      put "On card: " & TAB & c & cr & "Name:" & TAB & the short name of field f of cd c & \
          cr &"Nr.:" & TAB & f & cr & "ID:" & TAB & the id of field f of cd c & cr \
          & "W/H:" & TAB & the width of field f of cd c & ","   & the height of field f of cd c & CR &\
          "Loc:" & TAB & the loc of field f of cd c & cr & "Owner:" & TAB & the owner of field f of cd c &  cr &\
          "Style:" & TAB & the style of field f of cd c & CR & "Visible:" & TAB & the vis of field f of cd c & cr & cr &\
          "Text:" & CR & cr & the text of field f of cd c & CR & cr &\
          "HTML-text:" & CR & cr  & the htmltext of field f of cd c & CR &\
          cr & "Script:" & cr & CR & the script of field f of cd c & CR  & cr & "**************************" & CR & cr after infofld
    end repeat
    
    put the number of sbs of cd c into  anzsb
    repeat with s = 1 to anzsb
      put "On card: " & TAB & c & cr & "Name:" & TAB & the short name of sb s of cd c & \
          cr &"Nr.:" & TAB & s & cr & "ID:" & TAB & the id of sb s of cd c & cr \
          & "W/H:" & TAB & the width of sb s of cd c & ", " &  the height of sb s of cd c & CR &\
          "Loc:" & TAB & the loc of sb s of cd c & TAB & "Owner:" & TAB & the owner of sb s of cd c & cr &\
          "Style:" & TAB & the style of sb s of cd c & CR & "Visible:" & TAB & the vis of sb s of cd c & cr \
          & cr &  "Script:" & cr & cr  & the script of sb s of cd c & CR  & cr & "**************************" & CR & cr  after infosb
    end repeat
    
    put the number of images of cd c into  anzimg
    repeat with i = 1 to anzimg
      put "On card: " & TAB & c & cr & "Name:" & TAB & the short name of image i of cd c & \
          cr &"Nr.:" & TAB & i & cr & "ID:" & TAB & the id of image i of cd c & cr \
          & "W/H:" & TAB & the width of image i of cd c  & ", "   & the height of image i of cd c & CR &\
          "Loc:" & TAB & the loc of image i of cd c & cr & "Owner:" & TAB & the owner of image i of cd c & cr &\
          "Filename:" & TAB & the filename of image i of cd c & CR & "Visible:" & TAB & the vis of image i of cd c & cr\
          & cr &  "Script:" & cr & cr & the script of image i of cd c & CR  & cr & "**************************" & CR & cr after infoimg
    end repeat
    
    put the number of players of cd c into  anzpl
    repeat with p = 1 to anzpl
      put "On card: " & TAB & c & cr & "Name:" & TAB & the short name of player p of cd c & \
          cr &"Nr.:" & TAB & i & cr & "ID:" & TAB & the id of player p of cd c & cr \
          & "W/H:" & TAB & the width of player p of cd c  & ", "   & the height of player p of cd c & CR &\
          "Loc:" & TAB & the loc of player p of cd c & cr & "Owner:" & TAB & the owner of player p of cd c & cr &\
          "Filename:" & TAB & the filename of player p of cd c & CR  & "Visible:" & TAB & the vis of player p of cd c & cr\
          &  cr & "Script:" & cr & cr & the script of player p of cd c & CR  & cr & "**************************" & CR & cr after infopl
    end repeat
    
    put the number of grcs of cd c into  anzgrc
    repeat with gr = 1 to anzgrc
      put "On card: " & TAB & gr & cr & "Name:" & TAB & the short name of grc gr of cd c & \
          cr &"Nr.:" & TAB & gr & cr & "ID:" & TAB & the id of grc gr of cd c & cr \
          & "W/H:" & TAB & the width of grc gr of cd c  & ", "   & the height of grc gr of cd c & CR &\
          "Loc:" & TAB & the loc of grc gr of cd c & cr & "Owner:" & TAB & the owner of grc gr of cd c & cr &\
          "Style:" & TAB & the style of grc gr of cd c & CR & "Visible:" & TAB & the vis of grc gr of cd c & cr\
          & cr & "Script:" & cr & cr & the script of grc gr of cd c & CR  & cr & "**************************" & CR & cr after infogrc
    end repeat
    
    add anzgrp to totgrp
    add anzbtn to totbtn
    add anzfld to totfld
    add anzsb to totsb
    add anzimg to totimg
    add anzpl to totpl
    add anzgrc to totgrc
    
  end repeat
  
  Put "THE STACK" & cr & cr &"Filename:" & TAB & the effective filename of stack welcher & CR \
      & "Name:" & TAB & welcher & cr & "Title:" & TAB & the title of stack welcher  \
      & cr & "W/H:" & TAB & the width of stack welcher  & ", "  & the height of of stack welcher &  CR into infost
  
  Put cr & cr & "TOTAL:" & cr  & "Number of CDs:" & TAB & anzcd & cr & "Number of BGs:" & TAB & anzbg &  CR &\
      "Buttons: " & TAB & totbtn & CR & "Fields: " & TAB & totfld & CR & "Scrollbars: " & TAB & totsb\
      & CR & "Images: " & TAB & totimg & CR & "Players: " & TAB & totpl & CR & "Graphics: " & TAB & totgrc & CR after infost
  
  put  cr & "Script:" & cr & cr & the script of stack welcher & CR after infost
  
  set the defaultstack to "Analyze it..."
  get the datei of this stack
  go stack it
  
  set the defaultstack to "contentz"
  
  put infost into field 1 of cd "st"
  put "THE CARDS" & CR &  CR & "Total: " & anzcd & CR & cr & infocd into field 1 of cd "karten"
  put  "THE GROUPS" & CR & CR & "Total: " & totgrp & CR & cr & infogrp into field 1 of cd "g"
  put  "THE BUTTONS" & CR & CR & "Total: " & totbtn & CR & cr & infobtn into field 1 of cd "b"
  put "THE FIELDS" & CR  & CR & "Total: " & totfld & CR & cr &  infofld  into field 1 of cd "f"
  put "THE SCROLLBARS" & CR & CR &  "Total: " & totsb & CR & cr &  infosb into field 1 of cd "s"
  put  "THE IMAGES" & CR  & CR & "Total: " & totimg & CR & cr & infoimg into field 1 of cd "i"
  put  "THE PLAYERS" & CR & CR & "Total: " & totpl & CR & cr & infopl into field 1 of cd "p"
  put  "THE GRAPHICS" & CR & CR &  "Total: " & totgrc & CR & cr & infogrc into field 1 of cd "gr"
  
  set the name of stack  "contentz" to "Contents of " & welcher
end maches
  w              white       ~  z   datei 
#!/bin/sh
# MetaCard 2.4 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  	contentz 0  on mouseUp
  
end mouseUp
  w              white         y              U 
helvetica  
 U Lucida Grande    st   	@                  karten   	P on openCard
  
end openCard
                   g   	@                  b   	@                   f   	@                  s   	P on openCard
  
end openCard
                   i   	@                 	 p   	@                  gr   	@               
    )`        p        x          `      g        a       	_    navi   i          `   Stack Ep %on mouseUp
  go cd "st"
end mouseUp
         X $         	        Cards Ep )on mouseUp
  go cd "karten"
end mouseUp
        - X $         	        Groups Ep $on mouseUp
  go cd "g"
end mouseUp
        U X $         	        Buttons Ep $on mouseUp
  go cd "b"
end mouseUp
        | X $         	        Fields Ep %on mouseUp
   go cd "f"
end mouseUp
         X $         	        Scrollbars Ep %on mouseUp
   go cd "s"
end mouseUp
         X $         	        Images Ep $on mouseUp
  go cd "i"
end mouseUp
         X $         	        Player Ep $on mouseUp
  go cd "p"
end mouseUp
        X $         	        	Graphics Ep %on mouseUp
  go cd "gr"
end mouseUp
       B X $         	        Save stack ex    on mouseUp
  Ask file "Save this stack as..." with the short name of this stack & ".rev"
  if it is empty then exit mouseup
  if char -4 to -1 of it is not ".rev" then put ".rev" after it
  save this stack as it
end mouseUp
        X   Save
as stack...          	        	Save all ex   &on mouseUp
  Ask file "Save all infos as..." with (the short name of this stack & ".txt")
  if it is empty then exit mouseup
  repeat with i = 1 to the num of cds
    put fld 1 of cd i & CR & CR after rep
  end repeat
  delete char -2 to -1 of rep
  put rep into url("file:" & it)
end mouseUp
        X   Save all
as text...          	        
Save this ex   on mouseUp
put the number of this cd into dienummer
  Ask file "Save this field as..." with the short name of btn dienummer & " of " && word 3 to -1 of the short name of this stack & ".txt"
  if it is empty then exit mouseup
  put fld 1 into url("file:" & it)
end mouseUp
        X   Save THIS
as text...          	     
    )`        p        d          `      g        a       	_ 
    )`        p        d           `      g        a       	_ 
    )`        p        d            `      g        a       	_ 
    )`        p        d           `      g        a       	_ 
    )`        p        d           `      g        a       	_ 
    )`        p        d   	    
    `      g        a       	_ 
    )`        p        d       
    `      g        a       	_ 
    )`        p        P          `      g        a       	_           Analyze this stack...     
 U 
helvetica   U 
helvetica   U Lucida Grande  
 U Lucida Grande   U Lucida Grande  
 U Lucida Grande       	P <on openCard
  send "mouseup" to btn "refresh"
end openCard
            z                   Analyse that stack -> ex  {on mouseUp
  if the selectedtext of field "thestacks" is empty then
    beep
    exit mouseup
  end if
  put the the selectedtext of field "thestacks"  into elstack
  if  elstack is not in the openstacks then
    beep
    exit mouseup
  end if
  get the the selectedtext of field "thesubstacks"
  if it is empty then
    maches elstack
  else
    maches it
  end if
end mouseUp
           ' "Analyse that ->
stack/substack ->          	     
   
thestacks  )x  &on mouseUp
  if the substacks of stack (the selectedtext) is empty then
    put the short name of stack (the selectedtext) into fld thesubstacks
  else
    put the short name of stack (the selectedtext) &CR& the substacks of stack (the selectedtext) into fld thesubstacks
  end if
end mouseUp
          w @Click to list all substacks in the right field, if available...            Analyze it...  2lz3  Properties  MetaCard Menu Bar  Control Browser  Home       `    @ &   u    refresh ex   hon mouseUp
  put the openstacks into field "thestacks"
  put empty into fld "thesubstacks"
end mouseUp
         Q  ' Refresh stack-list          	        Info... Ex   mon mouseUp
  set the effectrate to 300
  show grp "klausi" with visual barn door open very slow
end mouseUp
         )  '         	        stack einlesen Ep non mouseUp
  answer file "Bitte, bitte..."
  set the datei of this stack to url("binfile:" & it)
end mouseUp
          t (         	        
stack ffnen Ep Don mouseUp
  get the datei of this stack
  go stack it
end mouseUp
          t (         	        klausi   a   don mouseUp
  set the effectrate to 300
  hide me with visual barn door close very slow
end mouseUp
       5 
     	h          -          	Enjoy...    Klaus Major  klaus@major-k.de    ESpecial thanks to Jos L. Rodrguez for adding the substack-support.           	d        A A *ceterum censeo microsoftiem esse delendam   GIF89aA A   bH:wxdVtSYKlSEsYHylFxf}uW7(̬|zz\D5Ys;ıgZʼjYrf|FGe7jui˲x-5)|VfŹmgWjS{wjxWpL6V4\vGHhAsYL%az<[eZxe캵Ħj:X)Tm5 &ϩùĺe=3ƯʩкdQ>ʼ2 x~Ҭy\QX;/ǡFc.v`NiM?ʶƍcaKebwk?
ȑzlH)#lL2$7H<y(EUhJCUE>e0&D(nvȴf{^ù؅JcQ\ph{qYuY˲hOğgpfm_6K/XA0|>]=湬¼X.$pXz{l\pF5qnNf,l}pi=w\˺vԻ,N8_pwTCʐA^-š`A1rq`嵎Ÿq
OOsEJBfFғɵj Op50R)ЭNoJim\MuN>wN3Oo]paͱ?FISZv3dֶw}κۿ^N2iGܬ:=+^X)̶lZoRɦsOhӬ!     ,    A A   !,$JPu"* tND GX'~|eĈF6(Z4^(`3"EJmXPA`D$T(#IDG''N֬Fq?~@AHq-EXR\0	
~hTIpn@ Izgj$XD	@G	5ƅޟtqvH$mIBE\QOr 
,dC:-y'R(@+DO}`F;ܸ	vK,O<@pA
ē+@S%Q2QP6bHM8hS(.ms@ `Vh;?S
ppB!|4N5tkdY
   Cҁ4"|[o0Í츃;\X;nQI-=.B QPOdÁ7
$R?t JhC$r 71^aF%DQC6W
!+	PxFT#v< ,("P
#U,V
7X0# 1c8G9 xa$R
@Xҋ4Ts#!PҌ0H4SPKm1jBXTH@YQyܝr<	(E1r: |C_@a;`G%"4yH@6؀E{teIrpí7ʽ
EcpM(R/dD9莀3Nwb%^MB2p -R o3Hl$L&pL7Xq?a#T}/BL8+M顗
b%A]4QBZC	\p*o@d@41{(ZP

/B.C'	A/ Y" ٽ" -|f *	xeq1/8@
4XUA"4 ;7p汇,#%p 8Jy@XP?mbQF+!DaQ,v4|HBV@rԀ`/4"qd	(A
}E0#Z4g": @
c I@ aI
tɅ/?`Ylx@	@n+ 3AH@08`ئ!@AȢh
ȑ'
I">:*A1K|M8f|Aղ& h3@ Dp/Ap@h'<!B#>p	_  KTD6x L`M0CG[@6%C <ȃOhlx(A<R|A*Ȃ >E
[P0	1(t,2h	7! v'XR^#|(dp'b7`o`?vTZ<h#
aA1 "B(
BPcx)ކ2p
Mgf7da/,^
8giE1U~H5yha E4T (HaQ(FLI/bA2A87td PɋBUZ  	nDu@(A lp!4,)6 
\`	-T#F aG"`a `$z@ .  \
?Џ:,0 d" sxAt,j d`׽ -abv/Ai}40hz,b!̫:`6l	N  e"8@
y@-  !V&Pc G/ш,4N<
`@FeydA24d@1<B׈5"3&(7:\
e_b07 0teyV
[j ?*87!QH@xӛ w+a;(
0X7`ip,npVЂԠ.U{@2.pd>Xlj0"搀/z S}Pttp p>wLbYǵ-0A	=A>? -T`k PSBBy1B)&	f+/ 
{~*`B
}?B"h 9X5*P@o5	NCtD"cԂKpT	~FEQ@b +w
e``/' /	p~8WU J xh 	 w E bE
r+W`9	90 
i
VX"PؖXP
^=0
 		q 9
0E}  rPep e	pPb	Ep~`~A'xv 
gh1z  m 

 v 9
Iv9 pP
<`0^`0UpmVX* z   	 vʰ| <	 p00	GI Y E%Y9~)`(kXz`
P נ k_Hpv9`

p7 )~%H=  zd(] @y    wP` r  ` 9	P040U0=
<u@	}p
}0=w  ` ݰ
! ЊS0D8	0;0j	J0PV8J
r	p
	0y
m  
qX 
0`  	2TP9 
h pwp g*Ȱ z  m ] r q 
=(p  	r`)9i1P

(pS ]$
wH]b (bp
Ǡ
1` sp>0@v  ? }r| zzp 0r
   EP
[P)
 
i)` 
 P
 
 }`?`
E GY0Prv djwLs

sPBP0` |Ӏ
E k
m
F dJb[pst&`m	`kPJ r` P]Ph   ĺ m	*
B7 H
w[	JЭ`Jzɛ}p  ֠
  qp 
(;T(UztPp	[0[


-(A  $pS]`
@r 8x
Zfzt p{	mгz }@m $ke r 
 ְ
0} *jҺCd'
=p9	&>k m` ~Y b` q $`
%:e 	l~JG~) 
+
܉{S [}eg
k 9(гk0
 x+;`৥ J qP
 
`bЫ}{w K "ְ> ^00	8v($ {TP|eCikw (`9/BЉn?j
$ AQ 0|X

r@A( w 0	|` $
| <6`ph`w \`*|
»HyrK̇.	
pi
qp~ yc<K`
P@mp
 鞡m76pDƾ0X
0	k@"i
|
z	 Kt6
 	.0	zsspvlQi[kkP]p
yvhzB!	
)P
y< 0Kǈ

{97Tq
 )[
x<	tltͼ|zP͊]7e0 |.D>=G.p`ʏphAMqk 7|x,KMPp pØZQ
]Ŵ@yǧ`8ݚ`p3 	v
	00vq63q
I۞:z7) @-P
ʐҀՏ
k	`
r ;     A A  
   
thesubstacks  )h       8   w 
Substacks...                   `    @    u    2lz3 prefs 2    on openstack
  ##
end openstack

on closestack
  ##
end closestack

on preopenstack
  get the vorprefs of stack "2lz3"
  repeat with i = 1 to 7
    set the hilite of btn i to line i of it
  end repeat
end preopenstack
  `                  2lz3 preferences     
 U Arial   U Arial   W Arial  
 U Arial   U Arial  
 W Arial       	P on openCard
  
end openCard
                      Cancel Ex   +on mouseUp
  close this stack
end mouseUp
         l          	        OK Mx   on mouseUp
  repeat with i = 1 to 7
    put the hilite of btn i & CR after neu
  end repeat
  delete char -1 of neu
  set the vorprefs of stack "2lz3" to neu
  close this stack
end mouseUp
        l          	        general 	 i          E   	tooltips @e        *    Show tooltips          	       pos @e        *    Remember loc & orientation          	    
    	          
 
D            General preferences:    
newstacks 	 i         \"
    	          
 bD            0Preferences for new stacks created with "2lz2":    alw @e        ~    
Alwaysbuffer          	       dest @e            Destroy stack on close          	       destw @e        ~    Destroy window on close          	       res @e            
Resizable          	       dnd @e Lon mouseUp
  set the enabled of fld "info" to the hilite of me
end mouseUp
        V   NPlease consider to comment these scripts out before building a standalone ;-)  5Add Drag'n'Drop functionality to new created stacks:          	    
   info 	8   on mouseUp
  
end mouseUp
         h         2     dThis will add two smart Drag'n'Drop scripts to the new stacks created with the "new stack" menu :-)    fYou will then be able to simply create a player, field or image and drag any file onto that object...    Hint:  Only ONE file is supported.     Hint for images:  <Dropping an image will set the filename of an image-object.  6Holding the ALT-key will import a copy of that image.    Cool, isn't it?!!! :-D    Important hint!!!  Start dragging a file from the desktop/finder/folder WITHOUT the ALT-key. Then press the ALT-key before dropping the file onto the image-object...    YPlease comment these scripts out, if your standalone does not need this functionality...    TDue to the lack of time, these smart scripts will only support files with a suffix!    OFuture versions may also support mac creator-codes, but not this one, sorry...    eThe following file-types are supported (and the script will take care of handling them correctly ;-)    2The scripts are NOT responsible for media-/codec-  )incompatibilities!!! Murphy's law... ;-)      Images:  ,".gif"	".giff"	".jpg"	".jpeg"	".png"	".bmp"    .Player-objects with QuickTime >= 5 installed:  Image files  ".tif"	".tiff"	".psd"	".tga"    Fields:  ".txt"	".html"	".htm"	".rtf"    #Audio/video with or WITHOUT QT ;-)  *".avi"	".mpg"	".mpeg"	".wav"	".aif"	".au"     Video with QT ;-)  "".mov"	".dv"	".swf" <= version 5	     Players on OS X ONLY:  ".pdf"    Enjoy!    Best from germany    
Klaus :-)       	       j      Favourites 3   
function namezuerst pfad
  set the itemdel to "/"
  put item -1 of pfad into datei
  return datei & TAB & pfad
end namezuerst

on preopenstack
  get the altloc of this stack
  if it <> 0 AND it <> empty then
    set the rect of this stack to line 1 of it
    put line 2 to -1 of it into fld "sl" of cd 1
  end if
end preopenstack

on openstack
  ##
end openstack

on closestack
  prefsschreiben (the rect of this stack & CR & fld "sl" of cd 1), 2
end closestack
  `      Ys e   altloc  1113,627,1279,984
         My favourite things...        
 U 
helvetica   U 
helvetica   W 
helvetica  
 U Arial   U Arial  
 U Lucida Grande  cREVGeneral    scriptChecksum  ʺ[Qzt
bookmarks   handlerList  ,namezuerst
preopenstack
openstack
closestackscriptSelection  char 365 to 364prevHandler  
closestacktempScript   script <p>function namezuerst pfad</p>
<p>  set the itemdel to &quot;/&quot;</p>
<p>  put item -1 of pfad into datei</p>
<p>  return datei &amp; TAB &amp; pfad</p>
<p>end namezuerst</p>
<p></p>
<p>on preopenstack</p>
<p>  if the altloc of this stack = 0 then exit preopenstack</p>
<p>  if the altloc of this stack = empty then exit preopenstack</p>
<p>  </p>
<p>    get prefslesen(2)</p>
<p>  if it &lt;&gt; &quot;nix&quot; then</p>
<p>    set the altloc of stack &quot;favourites&quot; to it</p>
<p>  end if</p>
<p></p>
<p>  </p>
<p>  get the altloc of this stack</p>
<p>  set the rect of this stack to line 1 of it</p>
<p>  put line 2 to -1 of it into fld &quot;sl&quot; of cd 1</p>
<p>end preopenstack</p>
<p></p>
<p>on openstack</p>
<p>  ##</p>
<p>end openstack</p>
<p></p>
<p>on closestack</p>
<p>  prefsschreiben (the rect of this stack &amp; CR &amp; fld &quot;sl&quot; of cd 1), 2</p>
<p>end closestack</p>
<p></p>      	Pon resizeStack
  get the rect of this card
  add 2 to item 1 of it
  add 2 to item 2 of it
  put item 4 of it into unten
  subtract 2 from item 3 of it
  subtract 44 from item 4 of it
  set the rect of field 1 to it 
  set the bottom of button 2 to unten - 17
  set the bottom of button 3 to unten - 23
  set the bottom of button 4 to unten - 2
  set the bottom of button 5 to unten - 2
end resizeStack
            e               lm @e       4    Lock messages          	       go stack... Ewon mouseUp
  put the selectedtext of fld "sl" into st
  if st = empty then exit mouseup
  if st = "-" then exit mouseup
  set the itemdel to TAB
  if the hilite of btn "lm" then set the lockmessages to true
  if there is a file (item 2 of st) then
    go stack (item 2 of st)
    choose browse tool
  else
    answer "File does not exist unfortunately..." with "Delete entry?" or "So what?"
    if it = "Delete entry?" then
      delete line (the hilitedlines of fld "sl") of fld "sl"
    end if
  end if
end mouseUp
       d; @  @Open the selected stack. Un/Check "Lock messages" as desired...          	        
add stack... Ew on mouseUp
  answer file "Please select a stack to add to the list..."
  if the result = "cancel" then exit mouseup
  if fld "sl" = empty then
    put namezuerst(it) into fld "sl"
  else
    put CR & namezuerst(it) after fld "sl"
  end if
end mouseUp
       P P  Add a stack to the list...          	        
delete entry Ew on mouseUp
  put the selectedtext of fld "sl" into st
  if st = empty then exit mouseup
  put the hilitedlines of fld "sl" into hl
  delete line hl of fld "sl"
end mouseUp
       TP P  0Deletes the selected line from the stacklist...          	     
   sl )y   on mousedoubleUp
  put the selectedtext of me into st
  if char 1 of st ="-" then exit mousedoubleup
  if  st = empty then exit mousedoubleup
  set the itemdel to TAB
  if the hilite of btn "lm" then set the lockmessages to true
  if there is a file (item 2 of st) then
    go stack (item 2 of st)
    choose browse tool
  else
    answer "File does not exist unfortunately..." with "Delete entry?" or "So what?"
    if it = "Delete entry?" then
      delete line (the hilitedlines of fld "sl") of fld "sl"
    end if
  end if
end mousedoubleUp

on mouseup wat
  if the mouseline = empty then exit mouseup
  set the hilitedlines of fld "sl" to word 2 of the mouseline
  if wat <> 1 then popup btn "mm"
end mouseup
         7     +Doubleclick to open/Ctrl-click for menu...                     `    @    *       a    @  ,      mm 	Umon menupick wat
  if the selectedtext of fld "sl" = empty then exit menupick
  switch word 1 of wat
  case "Open"
    send "mouseup" to btn "go stack..."
    break
  case "Delete"
    send "mouseup" to btn "delete entry"
    break
  case "Add"
    put CR & "-" after line (the hilitedlines of fld "sl") of fld "sl"
    break
  case "Up"
    put the selectedtext of fld "sl" into dertext
    if the hilitedlines of fld "sl" = 1 then exit menupick
    put the hilitedlines of fld "sl" into zeile
    delete line zeile of fld "sl"
    put dertext & CR before line (zeile - 1) of fld "sl"
    set the hilitedlines of fld "sl" to zeile - 1
    break
  case "Down"
    put the selectedtext of fld "sl" into dertext
    if dertext is empty then exit menupick
    if the hilitedlines of fld "sl" = the num of lines of fld "sl" then exit menupick
    put the hilitedlines of fld "sl" into zeile
    delete line zeile of fld "sl"
    put dertext & CR before line (zeile + 1) of fld "sl"
    if last char of fld "sl" is CR then delete last char of fld "sl"
    set the hilitedlines of fld "sl" to zeile + 1
    break
  end switch
end menupick
          X (   5Open
-
Delete entry
-
Add separator-line
-
Up
-
Down       	        
2lz3 help "  ton preopenstack
  set the decorations of this stack to ("title")
end preopenstack

on openstack
  ##
end openstack
  `       a V    	vorprefs            
2lz3 help       U Arial  
 U Arial   U Arial   W Arial   U Arial   W Arial  	 W Arial       	P on openCard
  ##
end openCard

on mouseenter
  if "button" is not in the target then exit mouseenter
  get the short name of the target
  set the htmltext of fld "info" to the it of this cd
end mouseenter
              b1  <p><b>open stack...</b></p>
<p></p>
<p>Will let you select ANY file on ANY platform!</p>
<p>If it is a valid stack, it will be opened...</p>
<p></p>
<p>Hold the ALT-key to lock messages.</p>b2  <p><b>Navigation buttons</b></p>
<p></p>
<p>Go to the previous, next, first or last card of the current stack</p>
<p></p>
<p>Hold the ALT-key to lock messages.</p>b3 	<p><b>go card...</b></p>
<p></p>
<p>This button will be filled &quot;on mouseenter&quot; with the short names of all the cards in the current stack (topstack)...</p>
<p></p>
<p>So they can be accessed directly. </p>
<p></p>
<p>Hold the ALT-key to lock messages.</p>b4  <p><b>misc...</b></p>
<p><p>
<p><b>Help...</b></p>
<p><b>Preferences...</b></p>
<p>Open the preferences and the help window from here...</p>
<p></p>
<p><b>Set directory...</b></p>
<p>Change/set &quot;the directory&quot;...</p>
<p></p>
<p><b>Answer file...</b></p>
<p>Here you can select a file and the complete path to this file will be put into clipboard and the message-box... (No more typos ;-)</p>
<p></p>
<p><b>Import...</b></p>
<p>Open the "import" palette...</p>
<p></p>

<p><b>Tools:</b></p>
<p>Provides some very smart tools... :-)</p>b5 <p><b>actions...</b></p>
<p></p>
<p>Select a menu and place the cursor over a stack of your choice...</p>
<p></p>
<p>Then the selected command will be &quot;sent&quot; to that stack in 2 seconds...</p>
<p></p>
<p>Press &quot;ESC&quot; to cancel the action...</p>
<p></p>
<p>Hint:</p>
<p>&quot;The messages&quot; will be &quot;locked&quot; automatically with menu-items 9 (close the mousestack) and 10 (clone the mousestack)!</p>b6 b<p><b>index</b></p>
<p><b>control browser</b></p>
<p></p>
<p>Click here to open the MC help index or the &quot;Control  Browser&quot;...</p>
<p></p>
<p></p>
<p><b>selgrob</b></p>
<p></p>
<p>Toggle &quot;the selectgroupedcontrols&quot; with this button...</p>
<p></p>
<p></p>
<p><b>new card</b></p>
<p></p>
<p>Will create a new card in the topstack...</p>b7  <p><b>new stack...</b></p>
<p></p>
<p>Here you can create a new stack with pre-defined or custom size...</p>
<p></p>
<p>If you set the preferences in the &quot;prefs&quot;-stack, they appropriate scripts will be applied to the new stack!</p>b8 P<p><b>card props</b></p>
<p><b>stack props</b></p>
<p></p>
<p>Click here to open the &quot;Property palette&quot; for the current card or stack...</p>
<p></p>
<p><b>obj script</b></p>
<p><b>card script</b></p>
<p><b>stack script</b></p>
<p></p>
<p>Will open the script-editor for the selected object(s), card or stack immediately...</p>b9 U<p><b>Set the width, height and/or location...</b></p>
<p></p>
<p>This field will be filled &quot;on mouseenter&quot; with &quot;the long id&quot; of the selected object...</p>
<p></p>
<p>Only ONE object is being supported here...</p>
<p></p>
<p>Enter a value for width (W), height (H), loc x (X) and loc y (Y) and hit RETURN or ENTER...</p>b10 <<p><b>del this cd !!!...</b></p>
<p></p>
<p>This will delete the current card of the topstack with a confirmation dialog!!!</p>
<p></p>
<p>Hold the ALT-key to suppress that dialog...</p>
<p></p>
<p><b>Handle with care!</b></p>
<p><b>Handle with care!</b></p>
<p><b>Handle with care!</b></p>
<p></p>
<p><b>;-)</b></p>b11  7<p><b>The TOOLS</b></p>
<p></p>
<p>You guess... ;-)</p>                              
   info 	h          B l |           actions... 
       
   BSelect a menu and place the cursor over a stack of your choice...    GThen the selected command will be "sent" to that stack in 2 seconds...    $Press "ESC" to cancel the action...    Hint:  v"The messages" will be "locked" automatically with menu-items 9 (close the mousestack) and 10 (clone the mousestack)! 
    	h          B   a           %Welcome to "2lz3" (Tools, too, 3 ;-) 
       $   \Move the cursor over the image on the left to get more info about the different controls...    OK Mx   Lon mouseUp
  close this stack
end mouseUp

on mouseenter
##
end mouseenter
         p          	        b1 Eg      * D          	        b2 Eg      8 D              	        b3 Eg      S D          	        b4 Eg       D          	        b5 Eg       D          	        b6 Eg     " D 9         	        b7 Eg     [ D          	        b8 Eg     i D B         	        b9 Eg      D H         	        b10 Eg      D          	        	2lz3.gif 	@           @  WGIF89a@   ]]]٩􄄦Y[s&'(X      !     ,    @  !d9
hl.x|R@$&Lrl:h A5Ej2X! t@Ȕ`5$JD g	w%RS 4S _~aY8osk+	{>Ik )G$KVfDK;"lDqA6ɈLHIRY(681*w@m*\p\# 
L8!MEU%fXQE'H QY
K^ʜ &͛ID
(U@ 	 pɋ)JfBuz	ꔕ9D0 *રFZX˶:<@Oxnÿ)2 Ir+` <^0!ʗ-c̹g8^6 ,p(m
]vX9S ,qFTsU`H	
νw׏ϡOy)cOY =jPƌqTI $)px1H VLYTQA!TPF]1G%QgtU/MTU,bVY\$WV4>/n	VҔA_P^tp@`^AY'`iG4u96I*S'^ٚy`fm|DlU۝eֆkLmn6p<Ucr-wr`Bt)LX}xjꩧPz`z@!H(R~$XB/DS29;4El(Ԉ`5UQtxl.SQD:UR8WBTUF @ȐшPse`Pa9f$XHrBZVgPv\Y֥d9D)|'_t!ކY' |FL϶hӐ
@&j
V)[CJ4m¨me*{{+=>_Ǟ/kGl$0MVEM*G=NjeWm!,XmS?u~@Y \U"{`SZfw
gpV@l`u<3&P Eύo4F
,M\Ore3aw{d:p'wy@4t5co:K%.$U,=q9_B+Tw]t/DzO$:ֵӓvPnvK(.
[B;.Dza@xGq063[ 6=/z_LG=ޱ4KBiP Ƨ6L SAj*H-rKb$GJZ2?V<|FXPeo#PE$ǬfEHIѪ%LlXl
[	`ц![@Q8FݼĢ?`>Pvǈ uQ^0'A)`KT\i44Ae2+=9 6eyxg;0mh[yvcA55ΠC)7졏E8"$#W(R~p
Rw_ZfJSP| Ӟ@CN[$t:*:NmBQTTu1PJTPkCRq>0RN2U(8*ʇ"u-e
vRT}l1\׺Uo
,Κ2OHl`1XCVvEl˃jj
,`7ʆ-Iq̲Ǜc pjo}kdn6

:ꆬ?f}Y87Hl>:moWET7un\]⵻Y_;vըmv[WP_[&P8_̍/hUcͫsorZbimo-`Esb:4Xtg8α[Z]|{e^J'%&<69:2V[dFY.62,VXtyIV2ג2X˚p.cfYq3atfK /,%zk}rj.Oe-Q+6 o,(Z5~pt!)3Aн84mrӌ~? V;ºѳiK]S,խ>l1yW]) mROvˤZi[8>tLdZkBV)o+UÜ|{NQ7=TԳ4NOxy\gRP~Uue9iPvcyӷ:4䇍vFܴUm%=<d\+5zQ[=08q<sS[y
C|_{Eb=Eutܔ>pk]ū|^HǎC]?|
ρfș@G
@)7^7yjA/+^t[>zܐߊvsG!<85jgۜz>7v19Q}Y=}Z=`y]m!zn}Vi}scF{rv_x&`X,tˆcqbyvwdhfrwq*pp,p28occ 1;qP#gxDF9N; C8kaFȃ惪5 LP腥okPf8jBx궆mXp{eX8 ObrxW	ȄmZWȃgghhc脉s_f Fl؄hn5Y@9e膺nqlVvt|PȘh=wg(hxyIh([bt˨ָR%OeRrm(u` VBNߨX
C֍18o:( zGHhuqXԈUوSۘZgXk4W\A~w땒ngmN嘐l%5),9
pEp9T+ЀeoH~ f't\tHS`/fkY<38qg/8cqFq|o*؅^F9SrgX(7]*Hasjm)skwxYuW`dqm瑠_Fɚ6aٕ{m1_uVZWQov]Ei@r_*iyIفW!fl(ցcu`zeoH|♙ 6$W)jU+))WVal	~w	;x e-
j
Z@b 1zh9WsDJO9s٤y)`ҕbg\SkU~W')}iTbڞ}5grk^ʞ`odztf%]RZ*IUʝ>ŨY)t'+ʣ-quAeS!SIm7D5I@.@	2A2, J8z,DASK.,oA!9;"c-1Bȴ<J0LL<2%q/eR.@DD$N"NCc9$t&Q&D2 @! TPHsO;vk}HLcHⱈRH^):I*Ss?*ī7'?JBԳ,RK*,s!?MEK&JQ	"R&E!"da"ފQk	>/GfP#ڴ/A#i#bc>b#MQ;VN" &$#00xQeB16# I{{#)1md#D=]IsR3xC>S(8eQ|PJ4uQбBTQQ- $΁-RS?)*JS8D p{6k<F
 { ;~ ;Fa k[ `36W>#{r`
+p!bP# BQq kFGp(d1(a#:#a p7|LC/$h P2Q`F1  p*ɹC/3#0? R<|QP+ (T!# $UR6õd\P =Sb 
Ȋȉ.eRbȌL|0лߚ ۽,p t\Ș,ͻfCIڲ,K+jrJJJ C;C,DML_[.vr-KA1akLcMQ! Mפٔ3F[aa0Hr1SNz k&##%nS'TO
=3;qP$3PSHs*5!;˹S*62ҵܫ{J<	>:=K#DK-7JK-мF=.Ha.tT.T!2bsC[9D<4L&1bTDY"I#IЙ[2`22JFo%=(];?A2S4jg+Ho WS
]
p6=ȻҤt0m2=˶\ӯ8
Կ7BKDL-Ƽ(2L1kV
L
'Kd+Uf{dMj#33\N@$Pt&Nuq#E&ON"KOj$2=c2B2tDAa.ƑFa{34<!
ҽ{sH4б"?$͝ۻ65r@
*-ۥB/[-˱<5ۿMiA1J,8STKPR.b;X-Zk"J/(4rAdmLzt1$-gŃ=,C0}BQ#
9 4yBvP>ͯRR#MT%>;ꪾ#3 248:0]mUu>J^	>A	A=:ۮQ~cU{Ob]1/d0ڬ݌3Lچ{#^#P%0N%$1kNTĸ k&5&nPPm!EQ~3]JLC(Q[sPeٮ~<Ap<1+ĭ K
B,]U $ν]L׌LN.T
R?Tw=]DlM"NSL#L0Qߐ] r2N-&&q$Gģё#_bG[ctûI7¾=n3}RGź+QC~T U0έGq.AU}~#!
Dj>cMN}BqrwQ qxXe%TQG6{
 $.@ 0+!W`tX~S['{'A8ʢ~а, !`HNFJ	\N.LrvVZvr`ZnZ: vfNbQ
#'+,;?C$T[_cgkoswkSTï'; k ;p!Bh/!Ê;qF?s(q${AD#˖N9Ndɚ6sfF>Y͢
E'ӃH~$jtjP-.mիR
/הYԵlȞi
ȗaݺvͫw/߻
<Y4g%
mq$[`5ˀdL@g /ú 1S\32]jw-}/7Ge[rҙO3]PBE&;TYZ6L6O}?ѽT>m}bq>5W5sX_!a	*(d9 c >FD5ķZe	tͧ;6j'!exh -}^C%OZ9GvVAi\NX"$9.ْ\8 ŖN)~b"K⧠
h0Bi0d0b]0PbJ)]Zjק^@V"P+(`kZ+kkh,,Ch 
:-*
p-ʭf+@d bJ
;ｙ/@k+DFzR0:@
S 1,H\,X|@C
Pb
0+-:('0h㊲dl6+mȌܶ1Zk#|"@؞ؒ}v,RF@awzM ;         b11 Eg      ` D          	        	einstein "    Hon openstack
  ##
end openstack

on preopenstack
  ##
end preopenstack
  `        e h         E=mc2      U Arial   U Arial   W Arial   U Arial   U Arial   W Arial   W Arial  
 U Arial       	P aon openCard
  put the openstacks into fld "ost"
  put the directory into fld "dir"
end openCard
           h       eins  i@        g
    	                        Current directory: 
   dir V	`       
  $           C:/Programme/MetaCard/Program       a    @   5     rel e   on mouseUp
  put the selectedtext of fld "ost" into auswahl
  if auswahl = empty then
    answer "Please select a stack from the list first..."
    exit mouseup
  end if
  put fld "dir" & "/" into ersetzen
  set the defaultstack to auswahl
  lock screen
  lock messages
  repeat with i = 1 to the num of cds
    set cursor to busy
    repeat with k = 1 to the num of images
      get the filename of image k of cd i
      if it = empty then next repeat
      replace ersetzen with "" in it
      set the filename of image k of cd i to it
    end repeat
    repeat with m = 1 to the num of players
      get the filename of player m of cd i
      if it = empty then next repeat
      replace ersetzen with "" in it
      set the filename of player m of cd i to it
    end repeat
  end repeat
  unlock screen
  unlock messages
  answer "Done!" & CR & "Don't forget to save stack" && auswahl & "!"
end mouseUp
         g  Create relative paths...          	     
   ost  )`       
 F            	einstein  2lz3  MetaCard Menu Bar  Home       `    @   G     set directory... Ew on mouseUp
  answer directory "Please select the new directory:"
  if the result = "cancel" then exit mouseup
  put it into fld "dir"
end mouseUp
        F           	     
    	`                    \Set the directory above, if necessary, select a stack from the list and click the button...    Et voila, relative paths!  "(...if possible, see the help...)    $The other button does what it says:  +It will import all your referenced images!    So you can work with referenced files, that MAY CHANGE, and then before you want to distribute your stack(s), run this little script, save your stack, and no more missing images :-)       	`    @        help e   lon mouseUp
  set the effectrate to 300
  show grp "hilfe" with visual barn door open very slow
end mouseUp
         F (  ?          	        close e    +on mouseUp
  close this stack
end mouseUp
        G  Close          	        import e   ~on mouseUp
  put the selectedtext of fld "ost" into auswahl
  if auswahl = empty then
    answer "Please select a stack from the list first..."
    exit mouseup
  end if
  set the defaultstack to auswahl
  lock screen
  lock messages
  repeat with i = 1 to the num of cds
    set cursor to busy
    repeat with k = 1 to the num of images of cd i
      get the filename of image k of cd i
      if it = empty then next repeat
      put url("binfile:" & it) into image k of cd i
    end repeat
  end repeat
  unlock screen
  unlock messages
  answer "Done!" & CR & "Don't forget to save stack" && QUOTE & auswahl & QUOTE & "!"
end mouseUp
           Import all referenced images          	        hilfe 	 aP lon mouseup
  set the effectrate to 300
  hide grp "hilfe" with visual barn door open very slow
end mouseup
           h  
    K@            projekt  i         JB    
einstein.gif 	@        N:   GIF89a:   0mZZ\I?0¹utu\KG\@fdy ȇ[X2ǆusߋ78:맦>#%!     ,    :  pH,Ȥrl:ШtJZجvzxL.zn[#?|Nۇ?D\{-4;wS%y"%E;/)zv6"")6p?)~6^).;)%??Ò%#"4.$O4"B®/ʪ;$*  ?./)@Z΄	 )`N;\`U8/Թب |Ó(`ߋX@A0 B)
USfhD۸Í7p2	$ʵkFK ͤRAj! pfIa@Dk3gH#L
]
΢8G
k
|39b|ikBͨ5^@b1׎!Ls>LŢ?|@ ^_V$eȕ3ߎ97aȁr_n	NƏʾ$@xwy 6tE@ME8le	.a-)0 	8&a( e7lb't@!U ușe+I+p2W8h t@<38uXTa $yQ&d5
`BdAK"ĥ"PjtAB '	3@gtfȱ.,Fjƙn	 
#8p)u	ZF
B#=+Hs:ij,;@0BFKfv+k=@Kk@H0(a;g%
"

Z7
.d,	;ۍTЂ
?-X< 
<6Lld"@B=`C@ L4<D
}d`5Ȍ[MBu#o6BF@6D,<X0u|;!7:ࡇ4$Bݹ@Js9 `CǜS^Hd"4 H/o'7G/Wogw/T觯2C6,2o` D`CL@FK G0@ 7ݢ	#ú&@	M
0.dȆ
p vC #1`ʀB!Pl_naK)C`C؀׸@~=e @@E, "(fÀ  
.v#I4id&1`DL!D pxXS0d.z1EQB&	!,9hh@Jґ
JW@c8>ɤHPvҐ~ T
]V$w@4b_&7`g; (L1p$/Q a4PT/AHE|? R`F	H<56s2J0;
A:Bh!#⡝"#Y#Wd#'cUZt&(3j">
{Cl-DEH./[Ki>r" A|`.be5ZP%㈨4Ӕƀ-=qzWih!jW.hD[f!zu4/9ɖ?DQ
i㓷
n)ltҶ;bsuW nפDXdhO1J8`!X/Qh:RX@țb -wX9h(焰U{
0@&;o_0&44BpqbːæX
ZC ]EVdb$p>""dP2/d@ 4qn4~[&c"_Ui%P~Z?~mc21j9¿%Cp184rqc?% 9i6`	5MkT[φXdbc|/Kĩ1gHU9<lcLĈw Le^@V۸j_\E12*OO&cU~wb<`ER;?(1p[@[6g'@#4Ceq>6Px2u1_Ojǔ頾 ~qaߢѽtl@
CNM5E
D:NC  [pw0'4A)R:,CvSOvwP	h㔕:| "Z*uכ=ۿ&8JOmn>h = {aOy^@Gy|P&}ҷCw~}s M~Gf0 FpQctpc{ Wx7/9&|."!#|7kQ0cb
ڷN6M3E1610z	gFem/6 LGxGWj` ?yNr !%WVqP .5S:X  MVz2Os;hJm 4*Qfgx(q(3
qb
cA1k%hH?  r8>l(Ҕ{ȇGX^np8R 7Gq(qR'a$#rP҉BИ0ȃ`uxzx.Ѩ2~1v^HtS	0cZX{m#3_ Y$$^r#AѸ8x/GBwݨ2 biC@ 
h0\fZ2#]r%Fu
))xl
4iˠ~@5Qb4_%hׅx"j|q|vsBS6߇w_2$ ew`C4 ` =)#/%`WiyY+P "BϷB0	B 
 cgv)ԍ#c؇
o?GrI/ 2b57Iq4G (&"a%P шDh)yl(	Y@-i ~ :X"P){B#",sD14FBiz6`BEVb 0
ӝe0?by:13R)0BڍBI$ʉBIxqyP
iqGt0W40p'Лw)'Bѹ@` &G6 W (`*(	iMp5$
tN72uU_R6	6P;z:TZ~ڜpiIA@ ˢ6D0PXp.nj?v0!TcT@keX@D ^Z(pS4@L@P TzؚJAC'u0:Zz蚮
'a*,p2Zz`k2 'HQQBX{
۰)c_@	%&ʰq~+
 2c1 7/`.^9CP٠'*0  б+N2@:{ZiZ* KQ&P[+ z" 5ݥsq` wbe 6C,  =+% ~"  `2'& &R+ ;'k$3/02B@p522\!P:#0C 3~`)(
/oA4
`1@  (eC 0 
7IQ0 NK@Qb
EsJ&02 &Pd+v;mU 0;4#6:R)5rz%%47?037V2k6,B297F07<X $<3/2C)3;P:B 013:˴v* Zy:bBRKAnW,  '`R[k+W 7j7.@0L60{7x1@5%@3c/G%$&-Tǎy8r34c ;BL2=3f^;  gL:{;\ƱEfK
koq9rgR-}L-A/<*$Cc6s΍77l4ǟ7Ws4rq3Y\͐`2,A;ĉA4i3	<kDKƀqZ<Pdy&0jvbRˉ&r\v@ `/,;b/[7Y0[
-PP>L/2Epq_{Μ36WL@T0i-!Q:7E9?2\1yiC6 IH kܯK̳FŀG{g|K|XQnn|oX&3^,r$I)c/%3V3/@0¹$LR!F- J . #35"G̞}ñc 3T=[*KI[׭,۳)A'P40+2P4`MWpi- RɃE0k6,=D DMo
.LIt..	%L "Ю{(*,.02>4^6~8:<>@B>D^F~HJLNPR>T	e;`	2>dH@NO4?$
f $O	JbJ%зA0OtaGHp~H]THDrX1m wQMHP/t	t#;  >u%`6[T^J @
w=r@a USj0-ppFҮ ؎oJEў^~p.	^a*̝q Xp)JUZp@xٮHQ.lK
>J!յW`oN@Oj9~W\
Y@."
 )?*ਰ[fj1_
 `'Pʲ t<Be+-.&nl
*PbJ8
@`-0I s
99P @Iޒn_N 'p#@9wPҤh'
jup?]1p	Ѐ0R8: 3  QPYG8䨢.0/@@@rz >0 OfM5Apz.<@ȿ 
b4Z,)2p>Q4"E@uP8DCLq|(lH$@bp q^DD!#%')vh::F^((*8F8
f\FfN*88\*"
( ZBHZ^zR
_b"L  QPbmv)w::R[Oz\hPONB[]mg3R"PuA
8 AŃ)HdNYYR8  (H0&6ؼAeKI "P3h4pAA(koGM9 
L [ޒd&dLqmP/LQRk[ocaai
%W >0h44
-Zp J>YiV;8eBAFDcX5DfׯIc9;\'d8p@P!B S`ـhc-6
@ %?z@՛Nh%8
ˠ;P &H0R @r!@ |@
Z܋>{P?lԉ76*p0`\hC 0щD=H!rHar@ (E)|o/7 !;z y'@@Bc:3M3j ڼoFl }SO
Lx '-'QlX@|X H@ :^5TZ<ahgh AhhUXOH:~7^zhBp@!
R׆hM"O;fQit
@hU^C"NUy>*؁Jd@cf
d@VgqAUSH!ps7-1v>}%A`AxnDhN؁h4:x3FaimjNëЍ Rr	$hϕ{tBX8>q{=pEhKqA/^OyA;{!\±\6t+arq'3v(@xKgCta{Pi%PR<{sB4`l_ʗk0?~`	u`jX  @y0`%9f') @|n#2`[Xc[A0az/N@xJA@E D0(ȃ A%1F@DMla]E+.(p<H.2D)m ?	D:3O(
nOh(d
X(2V"+eg
(H^˳wRN:@
?&A mKW3rbز5),EI 2=ؙ#8l禨Mysr=\>O5AP.
uC!:,D!Qr؃
FAh|tc'<2ԢՂt F8`=4M?(8<I$y4a{2WP@Ȏ/`CA	-X JF/<qATő/'|O
 k<bBA4=Z0e4^d1 "C@Ui9R XX
x +X* %ǩ;eԔZE}w RP8 ծjZ b-IEl]:u<(XR	6l)Rv䀐pݦ`ӐW1 ]@bCn6Y_׻$kuxJrU.1;q J
viV</x@:	u0
n -azڸlwً{NIlݘ [gE``mA!DۄRdyUB
7{Hf' H~т7 
;X/C2_Ö id
W$?he3W ?IrEyǌP#o[>AFl	\.ƶ%tJY)6BwB>)htc hrw*(`OP
\SٱvTsh~ۭa`aSwy<mK|[6Z'7p!+>L_uB!iPbN<[h[b
	6bF`[7[@IϜP8qPH ;            K                         K                       K      + q F &     , rp       K      3 a  6     4 b       K      ;  z       <       K        : "             K                
   hilfe 	                      This little helper will convert your absolute paths to your images and players into relative paths. This means relative to the current directory.    vThis will of course ONLY work, if your images and players (files) reside INSIDE this folder or one of its subfolders.      Click to continue... 
    	         
  d           Before "einstein":  )"C:/Folder1/My Project/media/wait2.gif"   OR  5"/Volumes/Ten/User/klaus/My Project/media/wait2.gif"    /After "Albert" did his work: "media/wait2.gif"       K            D D     h 